/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.LocalSecondaryIndex;
import com.amazonaws.services.dynamodbv2.model.transform.KeySchemaElementJsonMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.ProjectionJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;
import java.util.List;

public class LocalSecondaryIndexJsonMarshaller {
    private static LocalSecondaryIndexJsonMarshaller instance;

    public void marshall(LocalSecondaryIndex localSecondaryIndex, JSONWriter jsonWriter) {
        if (localSecondaryIndex == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<KeySchemaElement> keySchemaList;
            jsonWriter.object();
            if (localSecondaryIndex.getIndexName() != null) {
                jsonWriter.key("IndexName").value(localSecondaryIndex.getIndexName());
            }
            if ((keySchemaList = localSecondaryIndex.getKeySchema()) != null) {
                jsonWriter.key("KeySchema");
                jsonWriter.array();
                for (KeySchemaElement keySchemaListValue : keySchemaList) {
                    if (keySchemaListValue == null) continue;
                    KeySchemaElementJsonMarshaller.getInstance().marshall(keySchemaListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (localSecondaryIndex.getProjection() != null) {
                jsonWriter.key("Projection");
                ProjectionJsonMarshaller.getInstance().marshall(localSecondaryIndex.getProjection(), jsonWriter);
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static LocalSecondaryIndexJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new LocalSecondaryIndexJsonMarshaller();
        }
        return instance;
    }
}

