/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.directory.model.Attribute;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Computer
implements Serializable,
Cloneable {
    private String computerId;
    private String computerName;
    private ListWithAutoConstructFlag<Attribute> computerAttributes;

    public String getComputerId() {
        return this.computerId;
    }

    public void setComputerId(String computerId) {
        this.computerId = computerId;
    }

    public Computer withComputerId(String computerId) {
        this.computerId = computerId;
        return this;
    }

    public String getComputerName() {
        return this.computerName;
    }

    public void setComputerName(String computerName) {
        this.computerName = computerName;
    }

    public Computer withComputerName(String computerName) {
        this.computerName = computerName;
        return this;
    }

    public List<Attribute> getComputerAttributes() {
        if (this.computerAttributes == null) {
            this.computerAttributes = new ListWithAutoConstructFlag();
            this.computerAttributes.setAutoConstruct(true);
        }
        return this.computerAttributes;
    }

    public void setComputerAttributes(Collection<Attribute> computerAttributes) {
        if (computerAttributes == null) {
            this.computerAttributes = null;
            return;
        }
        ListWithAutoConstructFlag computerAttributesCopy = new ListWithAutoConstructFlag(computerAttributes.size());
        computerAttributesCopy.addAll(computerAttributes);
        this.computerAttributes = computerAttributesCopy;
    }

    public Computer withComputerAttributes(Attribute ... computerAttributes) {
        if (this.getComputerAttributes() == null) {
            this.setComputerAttributes(new ArrayList<Attribute>(computerAttributes.length));
        }
        for (Attribute value : computerAttributes) {
            this.getComputerAttributes().add(value);
        }
        return this;
    }

    public Computer withComputerAttributes(Collection<Attribute> computerAttributes) {
        if (computerAttributes == null) {
            this.computerAttributes = null;
        } else {
            ListWithAutoConstructFlag computerAttributesCopy = new ListWithAutoConstructFlag(computerAttributes.size());
            computerAttributesCopy.addAll(computerAttributes);
            this.computerAttributes = computerAttributesCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getComputerId() != null) {
            sb.append("ComputerId: " + this.getComputerId() + ",");
        }
        if (this.getComputerName() != null) {
            sb.append("ComputerName: " + this.getComputerName() + ",");
        }
        if (this.getComputerAttributes() != null) {
            sb.append("ComputerAttributes: " + this.getComputerAttributes());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getComputerId() == null ? 0 : this.getComputerId().hashCode());
        hashCode = 31 * hashCode + (this.getComputerName() == null ? 0 : this.getComputerName().hashCode());
        hashCode = 31 * hashCode + (this.getComputerAttributes() == null ? 0 : this.getComputerAttributes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Computer)) {
            return false;
        }
        Computer other = (Computer)obj;
        if (other.getComputerId() == null ^ this.getComputerId() == null) {
            return false;
        }
        if (other.getComputerId() != null && !other.getComputerId().equals(this.getComputerId())) {
            return false;
        }
        if (other.getComputerName() == null ^ this.getComputerName() == null) {
            return false;
        }
        if (other.getComputerName() != null && !other.getComputerName().equals(this.getComputerName())) {
            return false;
        }
        if (other.getComputerAttributes() == null ^ this.getComputerAttributes() == null) {
            return false;
        }
        return other.getComputerAttributes() == null || other.getComputerAttributes().equals(this.getComputerAttributes());
    }

    public Computer clone() {
        try {
            return (Computer)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

