/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.JsonErrorResponseHandler;
import com.amazonaws.http.JsonResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.directory.AWSDirectoryService;
import com.amazonaws.services.directory.model.ConnectDirectoryRequest;
import com.amazonaws.services.directory.model.ConnectDirectoryResult;
import com.amazonaws.services.directory.model.CreateAliasRequest;
import com.amazonaws.services.directory.model.CreateAliasResult;
import com.amazonaws.services.directory.model.CreateComputerRequest;
import com.amazonaws.services.directory.model.CreateComputerResult;
import com.amazonaws.services.directory.model.CreateDirectoryRequest;
import com.amazonaws.services.directory.model.CreateDirectoryResult;
import com.amazonaws.services.directory.model.CreateSnapshotRequest;
import com.amazonaws.services.directory.model.CreateSnapshotResult;
import com.amazonaws.services.directory.model.DeleteDirectoryRequest;
import com.amazonaws.services.directory.model.DeleteDirectoryResult;
import com.amazonaws.services.directory.model.DeleteSnapshotRequest;
import com.amazonaws.services.directory.model.DeleteSnapshotResult;
import com.amazonaws.services.directory.model.DescribeDirectoriesRequest;
import com.amazonaws.services.directory.model.DescribeDirectoriesResult;
import com.amazonaws.services.directory.model.DescribeSnapshotsRequest;
import com.amazonaws.services.directory.model.DescribeSnapshotsResult;
import com.amazonaws.services.directory.model.DisableRadiusRequest;
import com.amazonaws.services.directory.model.DisableRadiusResult;
import com.amazonaws.services.directory.model.DisableSsoRequest;
import com.amazonaws.services.directory.model.DisableSsoResult;
import com.amazonaws.services.directory.model.EnableRadiusRequest;
import com.amazonaws.services.directory.model.EnableRadiusResult;
import com.amazonaws.services.directory.model.EnableSsoRequest;
import com.amazonaws.services.directory.model.EnableSsoResult;
import com.amazonaws.services.directory.model.GetDirectoryLimitsRequest;
import com.amazonaws.services.directory.model.GetDirectoryLimitsResult;
import com.amazonaws.services.directory.model.GetSnapshotLimitsRequest;
import com.amazonaws.services.directory.model.GetSnapshotLimitsResult;
import com.amazonaws.services.directory.model.RestoreFromSnapshotRequest;
import com.amazonaws.services.directory.model.RestoreFromSnapshotResult;
import com.amazonaws.services.directory.model.UpdateRadiusRequest;
import com.amazonaws.services.directory.model.UpdateRadiusResult;
import com.amazonaws.services.directory.model.transform.AuthenticationFailedExceptionUnmarshaller;
import com.amazonaws.services.directory.model.transform.ClientExceptionUnmarshaller;
import com.amazonaws.services.directory.model.transform.ConnectDirectoryRequestMarshaller;
import com.amazonaws.services.directory.model.transform.ConnectDirectoryResultJsonUnmarshaller;
import com.amazonaws.services.directory.model.transform.CreateAliasRequestMarshaller;
import com.amazonaws.services.directory.model.transform.CreateAliasResultJsonUnmarshaller;
import com.amazonaws.services.directory.model.transform.CreateComputerRequestMarshaller;
import com.amazonaws.services.directory.model.transform.CreateComputerResultJsonUnmarshaller;
import com.amazonaws.services.directory.model.transform.CreateDirectoryRequestMarshaller;
import com.amazonaws.services.directory.model.transform.CreateDirectoryResultJsonUnmarshaller;
import com.amazonaws.services.directory.model.transform.CreateSnapshotRequestMarshaller;
import com.amazonaws.services.directory.model.transform.CreateSnapshotResultJsonUnmarshaller;
import com.amazonaws.services.directory.model.transform.DeleteDirectoryRequestMarshaller;
import com.amazonaws.services.directory.model.transform.DeleteDirectoryResultJsonUnmarshaller;
import com.amazonaws.services.directory.model.transform.DeleteSnapshotRequestMarshaller;
import com.amazonaws.services.directory.model.transform.DeleteSnapshotResultJsonUnmarshaller;
import com.amazonaws.services.directory.model.transform.DescribeDirectoriesRequestMarshaller;
import com.amazonaws.services.directory.model.transform.DescribeDirectoriesResultJsonUnmarshaller;
import com.amazonaws.services.directory.model.transform.DescribeSnapshotsRequestMarshaller;
import com.amazonaws.services.directory.model.transform.DescribeSnapshotsResultJsonUnmarshaller;
import com.amazonaws.services.directory.model.transform.DirectoryLimitExceededExceptionUnmarshaller;
import com.amazonaws.services.directory.model.transform.DirectoryUnavailableExceptionUnmarshaller;
import com.amazonaws.services.directory.model.transform.DisableRadiusRequestMarshaller;
import com.amazonaws.services.directory.model.transform.DisableRadiusResultJsonUnmarshaller;
import com.amazonaws.services.directory.model.transform.DisableSsoRequestMarshaller;
import com.amazonaws.services.directory.model.transform.DisableSsoResultJsonUnmarshaller;
import com.amazonaws.services.directory.model.transform.EnableRadiusRequestMarshaller;
import com.amazonaws.services.directory.model.transform.EnableRadiusResultJsonUnmarshaller;
import com.amazonaws.services.directory.model.transform.EnableSsoRequestMarshaller;
import com.amazonaws.services.directory.model.transform.EnableSsoResultJsonUnmarshaller;
import com.amazonaws.services.directory.model.transform.EntityAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.directory.model.transform.EntityDoesNotExistExceptionUnmarshaller;
import com.amazonaws.services.directory.model.transform.GetDirectoryLimitsRequestMarshaller;
import com.amazonaws.services.directory.model.transform.GetDirectoryLimitsResultJsonUnmarshaller;
import com.amazonaws.services.directory.model.transform.GetSnapshotLimitsRequestMarshaller;
import com.amazonaws.services.directory.model.transform.GetSnapshotLimitsResultJsonUnmarshaller;
import com.amazonaws.services.directory.model.transform.InsufficientPermissionsExceptionUnmarshaller;
import com.amazonaws.services.directory.model.transform.InvalidNextTokenExceptionUnmarshaller;
import com.amazonaws.services.directory.model.transform.InvalidParameterExceptionUnmarshaller;
import com.amazonaws.services.directory.model.transform.RestoreFromSnapshotRequestMarshaller;
import com.amazonaws.services.directory.model.transform.RestoreFromSnapshotResultJsonUnmarshaller;
import com.amazonaws.services.directory.model.transform.ServiceExceptionUnmarshaller;
import com.amazonaws.services.directory.model.transform.SnapshotLimitExceededExceptionUnmarshaller;
import com.amazonaws.services.directory.model.transform.UnsupportedOperationExceptionUnmarshaller;
import com.amazonaws.services.directory.model.transform.UpdateRadiusRequestMarshaller;
import com.amazonaws.services.directory.model.transform.UpdateRadiusResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AWSDirectoryServiceClient
extends AmazonWebServiceClient
implements AWSDirectoryService {
    private AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSDirectoryService.class);
    protected List<JsonErrorUnmarshaller> jsonErrorUnmarshallers;

    public AWSDirectoryServiceClient() {
        this(new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    public AWSDirectoryServiceClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AWSDirectoryServiceClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AWSDirectoryServiceClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(AWSDirectoryServiceClient.adjustClientConfiguration(clientConfiguration));
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AWSDirectoryServiceClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AWSDirectoryServiceClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AWSDirectoryServiceClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(AWSDirectoryServiceClient.adjustClientConfiguration(clientConfiguration), requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.jsonErrorUnmarshallers = new ArrayList<JsonErrorUnmarshaller>();
        this.jsonErrorUnmarshallers.add(new InsufficientPermissionsExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new DirectoryLimitExceededExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new UnsupportedOperationExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new SnapshotLimitExceededExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new ServiceExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new InvalidNextTokenExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new DirectoryUnavailableExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new AuthenticationFailedExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new EntityDoesNotExistExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new EntityAlreadyExistsExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new InvalidParameterExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new ClientExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshaller());
        this.setEndpoint("ds.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/directory/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/directory/request.handler2s"));
    }

    private static ClientConfiguration adjustClientConfiguration(ClientConfiguration orig) {
        ClientConfiguration config = orig;
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeSnapshotsResult describeSnapshots(DescribeSnapshotsRequest describeSnapshotsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeSnapshotsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeSnapshotsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeSnapshotsRequestMarshaller().marshall(super.beforeMarshalling(describeSnapshotsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DescribeSnapshotsResultJsonUnmarshaller unmarshaller = new DescribeSnapshotsResultJsonUnmarshaller();
            JsonResponseHandler<DescribeSnapshotsResult> responseHandler = new JsonResponseHandler<DescribeSnapshotsResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            DescribeSnapshotsResult describeSnapshotsResult = (DescribeSnapshotsResult)response.getAwsResponse();
            return describeSnapshotsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAliasResult createAlias(CreateAliasRequest createAliasRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createAliasRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateAliasRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateAliasRequestMarshaller().marshall(super.beforeMarshalling(createAliasRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            CreateAliasResultJsonUnmarshaller unmarshaller = new CreateAliasResultJsonUnmarshaller();
            JsonResponseHandler<CreateAliasResult> responseHandler = new JsonResponseHandler<CreateAliasResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            CreateAliasResult createAliasResult = (CreateAliasResult)response.getAwsResponse();
            return createAliasResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteSnapshotResult deleteSnapshot(DeleteSnapshotRequest deleteSnapshotRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteSnapshotRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteSnapshotRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteSnapshotRequestMarshaller().marshall(super.beforeMarshalling(deleteSnapshotRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DeleteSnapshotResultJsonUnmarshaller unmarshaller = new DeleteSnapshotResultJsonUnmarshaller();
            JsonResponseHandler<DeleteSnapshotResult> responseHandler = new JsonResponseHandler<DeleteSnapshotResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            DeleteSnapshotResult deleteSnapshotResult = (DeleteSnapshotResult)response.getAwsResponse();
            return deleteSnapshotResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateRadiusResult updateRadius(UpdateRadiusRequest updateRadiusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateRadiusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateRadiusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateRadiusRequestMarshaller().marshall(super.beforeMarshalling(updateRadiusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            UpdateRadiusResultJsonUnmarshaller unmarshaller = new UpdateRadiusResultJsonUnmarshaller();
            JsonResponseHandler<UpdateRadiusResult> responseHandler = new JsonResponseHandler<UpdateRadiusResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            UpdateRadiusResult updateRadiusResult = (UpdateRadiusResult)response.getAwsResponse();
            return updateRadiusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDirectoriesResult describeDirectories(DescribeDirectoriesRequest describeDirectoriesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeDirectoriesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeDirectoriesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeDirectoriesRequestMarshaller().marshall(super.beforeMarshalling(describeDirectoriesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DescribeDirectoriesResultJsonUnmarshaller unmarshaller = new DescribeDirectoriesResultJsonUnmarshaller();
            JsonResponseHandler<DescribeDirectoriesResult> responseHandler = new JsonResponseHandler<DescribeDirectoriesResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            DescribeDirectoriesResult describeDirectoriesResult = (DescribeDirectoriesResult)response.getAwsResponse();
            return describeDirectoriesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectDirectoryResult connectDirectory(ConnectDirectoryRequest connectDirectoryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(connectDirectoryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ConnectDirectoryRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ConnectDirectoryRequestMarshaller().marshall(super.beforeMarshalling(connectDirectoryRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ConnectDirectoryResultJsonUnmarshaller unmarshaller = new ConnectDirectoryResultJsonUnmarshaller();
            JsonResponseHandler<ConnectDirectoryResult> responseHandler = new JsonResponseHandler<ConnectDirectoryResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            ConnectDirectoryResult connectDirectoryResult = (ConnectDirectoryResult)response.getAwsResponse();
            return connectDirectoryResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateSnapshotResult createSnapshot(CreateSnapshotRequest createSnapshotRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createSnapshotRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateSnapshotRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateSnapshotRequestMarshaller().marshall(super.beforeMarshalling(createSnapshotRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            CreateSnapshotResultJsonUnmarshaller unmarshaller = new CreateSnapshotResultJsonUnmarshaller();
            JsonResponseHandler<CreateSnapshotResult> responseHandler = new JsonResponseHandler<CreateSnapshotResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            CreateSnapshotResult createSnapshotResult = (CreateSnapshotResult)response.getAwsResponse();
            return createSnapshotResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDirectoryResult deleteDirectory(DeleteDirectoryRequest deleteDirectoryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteDirectoryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteDirectoryRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteDirectoryRequestMarshaller().marshall(super.beforeMarshalling(deleteDirectoryRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DeleteDirectoryResultJsonUnmarshaller unmarshaller = new DeleteDirectoryResultJsonUnmarshaller();
            JsonResponseHandler<DeleteDirectoryResult> responseHandler = new JsonResponseHandler<DeleteDirectoryResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            DeleteDirectoryResult deleteDirectoryResult = (DeleteDirectoryResult)response.getAwsResponse();
            return deleteDirectoryResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDirectoryLimitsResult getDirectoryLimits(GetDirectoryLimitsRequest getDirectoryLimitsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getDirectoryLimitsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetDirectoryLimitsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetDirectoryLimitsRequestMarshaller().marshall(super.beforeMarshalling(getDirectoryLimitsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            GetDirectoryLimitsResultJsonUnmarshaller unmarshaller = new GetDirectoryLimitsResultJsonUnmarshaller();
            JsonResponseHandler<GetDirectoryLimitsResult> responseHandler = new JsonResponseHandler<GetDirectoryLimitsResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            GetDirectoryLimitsResult getDirectoryLimitsResult = (GetDirectoryLimitsResult)response.getAwsResponse();
            return getDirectoryLimitsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisableSsoResult disableSso(DisableSsoRequest disableSsoRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disableSsoRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DisableSsoRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DisableSsoRequestMarshaller().marshall(super.beforeMarshalling(disableSsoRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DisableSsoResultJsonUnmarshaller unmarshaller = new DisableSsoResultJsonUnmarshaller();
            JsonResponseHandler<DisableSsoResult> responseHandler = new JsonResponseHandler<DisableSsoResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            DisableSsoResult disableSsoResult = (DisableSsoResult)response.getAwsResponse();
            return disableSsoResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnableRadiusResult enableRadius(EnableRadiusRequest enableRadiusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(enableRadiusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<EnableRadiusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new EnableRadiusRequestMarshaller().marshall(super.beforeMarshalling(enableRadiusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            EnableRadiusResultJsonUnmarshaller unmarshaller = new EnableRadiusResultJsonUnmarshaller();
            JsonResponseHandler<EnableRadiusResult> responseHandler = new JsonResponseHandler<EnableRadiusResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            EnableRadiusResult enableRadiusResult = (EnableRadiusResult)response.getAwsResponse();
            return enableRadiusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateComputerResult createComputer(CreateComputerRequest createComputerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createComputerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateComputerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateComputerRequestMarshaller().marshall(super.beforeMarshalling(createComputerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            CreateComputerResultJsonUnmarshaller unmarshaller = new CreateComputerResultJsonUnmarshaller();
            JsonResponseHandler<CreateComputerResult> responseHandler = new JsonResponseHandler<CreateComputerResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            CreateComputerResult createComputerResult = (CreateComputerResult)response.getAwsResponse();
            return createComputerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnableSsoResult enableSso(EnableSsoRequest enableSsoRequest) {
        ExecutionContext executionContext = this.createExecutionContext(enableSsoRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<EnableSsoRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new EnableSsoRequestMarshaller().marshall(super.beforeMarshalling(enableSsoRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            EnableSsoResultJsonUnmarshaller unmarshaller = new EnableSsoResultJsonUnmarshaller();
            JsonResponseHandler<EnableSsoResult> responseHandler = new JsonResponseHandler<EnableSsoResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            EnableSsoResult enableSsoResult = (EnableSsoResult)response.getAwsResponse();
            return enableSsoResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDirectoryResult createDirectory(CreateDirectoryRequest createDirectoryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createDirectoryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateDirectoryRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateDirectoryRequestMarshaller().marshall(super.beforeMarshalling(createDirectoryRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            CreateDirectoryResultJsonUnmarshaller unmarshaller = new CreateDirectoryResultJsonUnmarshaller();
            JsonResponseHandler<CreateDirectoryResult> responseHandler = new JsonResponseHandler<CreateDirectoryResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            CreateDirectoryResult createDirectoryResult = (CreateDirectoryResult)response.getAwsResponse();
            return createDirectoryResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RestoreFromSnapshotResult restoreFromSnapshot(RestoreFromSnapshotRequest restoreFromSnapshotRequest) {
        ExecutionContext executionContext = this.createExecutionContext(restoreFromSnapshotRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RestoreFromSnapshotRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RestoreFromSnapshotRequestMarshaller().marshall(super.beforeMarshalling(restoreFromSnapshotRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            RestoreFromSnapshotResultJsonUnmarshaller unmarshaller = new RestoreFromSnapshotResultJsonUnmarshaller();
            JsonResponseHandler<RestoreFromSnapshotResult> responseHandler = new JsonResponseHandler<RestoreFromSnapshotResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            RestoreFromSnapshotResult restoreFromSnapshotResult = (RestoreFromSnapshotResult)response.getAwsResponse();
            return restoreFromSnapshotResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisableRadiusResult disableRadius(DisableRadiusRequest disableRadiusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disableRadiusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DisableRadiusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DisableRadiusRequestMarshaller().marshall(super.beforeMarshalling(disableRadiusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DisableRadiusResultJsonUnmarshaller unmarshaller = new DisableRadiusResultJsonUnmarshaller();
            JsonResponseHandler<DisableRadiusResult> responseHandler = new JsonResponseHandler<DisableRadiusResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            DisableRadiusResult disableRadiusResult = (DisableRadiusResult)response.getAwsResponse();
            return disableRadiusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSnapshotLimitsResult getSnapshotLimits(GetSnapshotLimitsRequest getSnapshotLimitsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getSnapshotLimitsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetSnapshotLimitsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetSnapshotLimitsRequestMarshaller().marshall(super.beforeMarshalling(getSnapshotLimitsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            GetSnapshotLimitsResultJsonUnmarshaller unmarshaller = new GetSnapshotLimitsResultJsonUnmarshaller();
            JsonResponseHandler<GetSnapshotLimitsResult> responseHandler = new JsonResponseHandler<GetSnapshotLimitsResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            GetSnapshotLimitsResult getSnapshotLimitsResult = (GetSnapshotLimitsResult)response.getAwsResponse();
            return getSnapshotLimitsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    @Override
    public DescribeSnapshotsResult describeSnapshots() throws AmazonServiceException, AmazonClientException {
        return this.describeSnapshots(new DescribeSnapshotsRequest());
    }

    @Override
    public DescribeDirectoriesResult describeDirectories() throws AmazonServiceException, AmazonClientException {
        return this.describeDirectories(new DescribeDirectoriesRequest());
    }

    @Override
    public GetDirectoryLimitsResult getDirectoryLimits() throws AmazonServiceException, AmazonClientException {
        return this.getDirectoryLimits(new GetDirectoryLimitsRequest());
    }

    @Override
    public void setEndpoint(String endpoint) {
        super.setEndpoint(endpoint);
    }

    @Override
    public void setEndpoint(String endpoint, String serviceName, String regionId) throws IllegalArgumentException {
        super.setEndpoint(endpoint, serviceName, regionId);
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        AWSCredentials credentials;
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.CredentialsRequestTime);
        try {
            credentials = this.awsCredentialsProvider.getCredentials();
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.CredentialsRequestTime);
        }
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setCredentials(credentials);
        JsonErrorResponseHandler errorResponseHandler = new JsonErrorResponseHandler(this.jsonErrorUnmarshallers);
        Response result = this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
        return result;
    }
}

