/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.sync.endpoint;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import org.duracloud.common.util.ChecksumUtil;
import org.duracloud.common.util.MimetypeUtil;
import org.duracloud.sync.endpoint.MonitoredFileInputStream;

public class MonitoredFile {
    private File file;
    private MonitoredFileInputStream stream;
    private String checksum;
    private String mimetype;

    public MonitoredFile(File file) {
        this.file = file;
        this.stream = null;
        this.checksum = null;
        this.mimetype = null;
    }

    public File getFile() {
        return this.file;
    }

    public boolean exists() {
        return this.file.exists();
    }

    public String getName() {
        return this.file.getName();
    }

    public String getAbsolutePath() {
        return this.file.getAbsolutePath();
    }

    public long length() {
        return this.file.length();
    }

    public URI toURI() {
        return this.file.toURI();
    }

    public long getStreamBytesRead() {
        if (null == this.stream) {
            return 0L;
        }
        return this.stream.getBytesRead();
    }

    public MonitoredFileInputStream getStream() {
        if (null == this.stream) {
            try {
                this.stream = new MonitoredFileInputStream(this.file);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("Could not get stream for file: " + this.file.getAbsolutePath() + " due to " + e.getMessage(), e);
            }
        }
        return this.stream;
    }

    public String getChecksum() {
        if (null == this.checksum) {
            this.checksum = this.computeChecksum(this.file);
        }
        return this.checksum;
    }

    private String computeChecksum(File file) {
        try {
            ChecksumUtil cksumUtil = new ChecksumUtil(ChecksumUtil.Algorithm.MD5);
            return cksumUtil.generateChecksum(file);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("File not found: " + file.getAbsolutePath(), e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getMimetype() {
        if (null == this.mimetype) {
            this.mimetype = this.computeMimetype();
        }
        return this.mimetype;
    }

    private String computeMimetype() {
        MimetypeUtil mimeUtil = new MimetypeUtil();
        return mimeUtil.getMimeType(this.file);
    }
}

