/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.sync.backup;

import java.io.File;
import org.duracloud.sync.config.SyncToolConfig;
import org.duracloud.sync.mgmt.ChangedList;
import org.duracloud.sync.util.DirectoryUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangedListBackupManager
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(ChangedListBackupManager.class);
    public static final int SAVED_BACKUPS = 3;
    private File backupDir;
    private long backupFrequency;
    private ChangedList changedList;
    private boolean continueBackup;
    private long changedListVersion;
    private SyncToolConfig config;

    public ChangedListBackupManager(ChangedList changedList, File backupDir, long backupFrequency, SyncToolConfig syncConfig) {
        this.backupDir = new File(backupDir, "changeList");
        if (!this.backupDir.exists()) {
            this.backupDir.mkdir();
        }
        this.backupFrequency = backupFrequency;
        this.changedList = changedList;
        this.config = syncConfig;
        this.continueBackup = true;
    }

    public long loadBackup() {
        long backupTime = -1L;
        File[] backupDirFiles = this.getSortedBackupDirFiles();
        if (backupDirFiles.length > 0) {
            File latestBackup = backupDirFiles[0];
            try {
                backupTime = Long.parseLong(latestBackup.getName());
                this.changedList.restore(latestBackup, this.config.getContentDirs());
            }
            catch (NumberFormatException e) {
                this.logger.error("Unable to load changed list backup. File in changed list backup dir has invalid name: " + latestBackup.getName());
                backupTime = -1L;
            }
        }
        return backupTime;
    }

    @Override
    public void run() {
        while (this.continueBackup) {
            if (this.changedListVersion < this.changedList.getVersion()) {
                this.cleanupBackupDir(3);
                String filename = String.valueOf(System.currentTimeMillis());
                File persistFile = new File(this.backupDir, filename);
                this.changedListVersion = this.changedList.persist(persistFile);
            }
            try {
                Thread.sleep(this.backupFrequency);
            }
            catch (InterruptedException e) {
                this.logger.warn("ChangedListBackupManager thread interrupted");
            }
        }
    }

    private void cleanupBackupDir(int keep) {
        File[] backupDirFiles = this.getSortedBackupDirFiles();
        if (backupDirFiles.length > keep) {
            for (int i = keep; i < backupDirFiles.length; ++i) {
                backupDirFiles[i].delete();
            }
        }
    }

    private File[] getSortedBackupDirFiles() {
        return DirectoryUtil.listFilesSortedByModDate(this.backupDir);
    }

    public void endBackup() {
        this.continueBackup = false;
    }

    public boolean hasBackups() {
        return this.getSortedBackupDirFiles().length > 0;
    }
}

