/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.common.collection;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.duracloud.common.collection.IteratorSource;

public class StreamingIterator<T>
implements Iterator<T> {
    private Queue<T> queue = new LinkedList<T>();
    private IteratorSource<T> source;

    public StreamingIterator(IteratorSource<T> source) {
        this.source = source;
    }

    @Override
    public synchronized boolean hasNext() {
        if (!this.queue.isEmpty()) {
            return true;
        }
        Collection<T> chunk = this.source.getNext();
        if (chunk != null) {
            for (T item : chunk) {
                this.queue.add(item);
            }
        }
        return this.queue.size() > 0;
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            return this.queue.remove();
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

