/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.duradmin.spaces.controller;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.http.HttpServletResponse;
import org.duracloud.client.ContentStore;
import org.duracloud.client.ContentStoreManager;
import org.duracloud.common.constant.ManifestFormat;
import org.duracloud.common.util.DateUtil;
import org.duracloud.common.util.IOUtil;
import org.duracloud.error.ContentStoreException;
import org.duracloud.error.NotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/manifest"})
public class ManifestController {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private ContentStoreManager contentStoreManager;

    @Autowired
    public ManifestController(@Qualifier(value="contentStoreManager") ContentStoreManager contentStoreManager) {
        this.contentStoreManager = contentStoreManager;
    }

    @RequestMapping(value={"/{storeId}/{spaceId:.*}"}, method={RequestMethod.GET})
    public String get(@PathVariable(value="storeId") String storeId, @PathVariable(value="spaceId") String spaceId, @RequestParam(value="format") String manifestFormat, HttpServletResponse response) throws Exception {
        try {
            ContentStore contentStore = this.contentStoreManager.getContentStore(storeId);
            ManifestFormat format = ManifestFormat.valueOf((String)manifestFormat.toUpperCase());
            InputStream is = contentStore.getManifest(spaceId, format);
            String extension = "txt";
            if (format.equals((Object)ManifestFormat.TSV)) {
                extension = "tsv";
            }
            StringBuffer contentDisposition = new StringBuffer();
            contentDisposition.append("attachment;");
            contentDisposition.append("filename=\"");
            SimpleDateFormat dateFormat = new SimpleDateFormat(DateUtil.DateFormat.PLAIN_FORMAT.getPattern());
            contentDisposition.append("manifest-" + storeId + "-" + spaceId + "-" + dateFormat.format(new Date()) + "." + extension);
            contentDisposition.append("\"");
            response.setHeader("Content-Disposition", contentDisposition.toString());
            IOUtil.copy((InputStream)is, (OutputStream)response.getOutputStream());
        }
        catch (NotFoundException ex) {
            response.setStatus(404);
        }
        catch (IOException | ContentStoreException ex) {
            response.setStatus(500);
        }
        return null;
    }
}

