/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.duradmin.spaces.controller;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang.StringUtils;
import org.duracloud.client.ContentStore;
import org.duracloud.client.ContentStoreManager;
import org.duracloud.client.task.S3TaskClient;
import org.duracloud.client.task.S3TaskClientManager;
import org.duracloud.duradmin.domain.ContentItem;
import org.duracloud.duradmin.util.PropertiesUtils;
import org.duracloud.duradmin.util.SpaceUtil;
import org.duracloud.error.ContentStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/spaces/content"})
public class ContentItemController {
    protected final Logger log = LoggerFactory.getLogger(ContentItemController.class);
    private ContentStoreManager contentStoreManager;
    private S3TaskClientManager taskClientManager;

    @Autowired
    public ContentItemController(@Qualifier(value="contentStoreManager") ContentStoreManager contentStoreManager) {
        this.contentStoreManager = contentStoreManager;
        this.taskClientManager = new S3TaskClientManager(contentStoreManager);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public ModelAndView delete(@Valid ContentItem contentItem, BindingResult result) throws Exception {
        String spaceId = contentItem.getSpaceId();
        ContentStore contentStore = this.getContentStore(contentItem);
        contentStore.deleteContent(spaceId, contentItem.getContentId());
        return this.createModel(contentItem);
    }

    @RequestMapping(value={""}, method={RequestMethod.GET})
    public ModelAndView get(HttpServletRequest request, HttpServletResponse response, ContentItem ci, BindingResult result) throws Exception {
        ContentItem contentItem = new ContentItem();
        try {
            this.populateContentItem(request, this.getContentStore(ci), ci, contentItem);
            if (!StringUtils.isBlank((String)contentItem.getContentId())) {
                return this.createModel(contentItem);
            }
            return new ModelAndView("jsonView", "contentItem", null);
        }
        catch (ContentStoreException ex) {
            ex.printStackTrace();
            response.setStatus(404);
            return new ModelAndView("jsonView", "contentItem", null);
        }
    }

    @RequestMapping(value={"streaming-url"}, method={RequestMethod.GET})
    public ModelAndView getStreamingUrl(HttpServletRequest request, HttpServletResponse response, ContentItem contentItem, BindingResult result) throws Exception {
        try {
            String streamingType = request.getParameter("streamingType");
            S3TaskClient taskClient = this.getTaskClient(contentItem);
            String urlToStream = "SECURE".equals(streamingType) ? taskClient.getSignedUrl(contentItem.getSpaceId(), contentItem.getContentId(), null, 20, null).getSignedUrl() : taskClient.getUrl(contentItem.getSpaceId(), contentItem.getContentId(), null).getStreamUrl();
            HashMap<String, String> responseMap = new HashMap<String, String>();
            int breakPoint = urlToStream.indexOf("/cfx/st") + 7;
            responseMap.put("prefix", urlToStream.substring(0, breakPoint));
            responseMap.put("suffix", urlToStream.substring(breakPoint + 1, urlToStream.length()));
            return new ModelAndView("jsonView", "streamingUrl", responseMap);
        }
        catch (ContentStoreException ex) {
            ex.printStackTrace();
            response.setStatus(404);
            return new ModelAndView("jsonView", "streamingUrl", null);
        }
    }

    @RequestMapping(value={"hls-url"}, method={RequestMethod.GET})
    public ModelAndView getHlsUrl(HttpServletRequest request, HttpServletResponse response, ContentItem contentItem, BindingResult result) throws Exception {
        try {
            String streamingType = request.getParameter("hlsStreamingType");
            S3TaskClient taskClient = this.getTaskClient(contentItem);
            String urlToStream = "SECURE".equals(streamingType) ? taskClient.getHlsUrl(contentItem.getSpaceId(), contentItem.getContentId()).getStreamUrl() : taskClient.getHlsUrl(contentItem.getSpaceId(), contentItem.getContentId()).getStreamUrl();
            HashMap<String, String> responseMap = new HashMap<String, String>();
            responseMap.put("streamingUrl", urlToStream);
            return new ModelAndView("jsonView", "streamingInfo", responseMap);
        }
        catch (ContentStoreException ex) {
            ex.printStackTrace();
            response.setStatus(404);
            return new ModelAndView("jsonView", "streamingInfo", null);
        }
    }

    @RequestMapping(value={"/update-properties"}, method={RequestMethod.POST})
    public ModelAndView updateContentProperties(HttpServletRequest request, @RequestParam String method, HttpServletResponse response, @Valid ContentItem contentItem, BindingResult results) throws Exception {
        try {
            String spaceId = contentItem.getSpaceId();
            String contentId = contentItem.getContentId();
            ContentStore contentStore = this.getContentStore(contentItem);
            ContentItem result = new ContentItem();
            Map properties = contentStore.getContentProperties(spaceId, contentId);
            PropertiesUtils.handle(method, "space [" + spaceId + "]", properties, request);
            contentStore.setContentProperties(spaceId, contentId, properties);
            this.populateContentItem(request, contentStore, contentItem, result);
            return this.createModel(result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    @RequestMapping(value={"/change-mimetype"}, method={RequestMethod.POST})
    public ModelAndView changeMimeType(HttpServletRequest request, HttpServletResponse response, @Valid ContentItem contentItem, BindingResult results) throws Exception {
        try {
            String spaceId = contentItem.getSpaceId();
            String contentId = contentItem.getContentId();
            ContentStore contentStore = this.getContentStore(contentItem);
            ContentItem result = new ContentItem();
            Map properties = contentStore.getContentProperties(spaceId, contentId);
            String mimetype = contentItem.getContentMimetype();
            String oldMimetype = (String)properties.get("content-mimetype");
            if (!StringUtils.isBlank((String)mimetype) && !mimetype.equals(oldMimetype)) {
                properties.put("content-mimetype", mimetype);
                contentStore.setContentProperties(spaceId, contentId, properties);
            }
            this.populateContentItem(request, contentStore, contentItem, result);
            return this.createModel(result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    @RequestMapping(value={"/copy"}, method={RequestMethod.POST})
    public ModelAndView copy(HttpServletRequest request, HttpServletResponse response, @Valid ContentItem contentItem, BindingResult result) throws Exception {
        try {
            String spaceId = contentItem.getSpaceId();
            String contentId = contentItem.getContentId();
            ContentStore contentStore = this.getContentStore(contentItem);
            return this.handleCopyContentItem(request, contentItem, spaceId, contentId, contentStore);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    private ModelAndView handleCopyContentItem(HttpServletRequest request, ContentItem contentItem, String spaceId, String contentId, ContentStore contentStore) throws ContentStoreException, MalformedURLException {
        String destStoreId = request.getParameter("destStoreId");
        String destSpaceId = request.getParameter("destSpaceId");
        String destContentId = request.getParameter("destContentId");
        if (Boolean.valueOf(request.getParameter("deleteOriginal")).booleanValue()) {
            contentStore.moveContent(spaceId, contentId, destStoreId, destSpaceId, destContentId);
        } else {
            contentStore.copyContent(spaceId, contentId, destStoreId, destSpaceId, destContentId);
        }
        ContentItem result = new ContentItem();
        result.setStoreId(destStoreId);
        result.setSpaceId(destSpaceId);
        result.setContentId(destContentId);
        if (!contentStore.getStoreId().equals(result.getStoreId())) {
            contentStore = this.getContentStore(result);
        }
        this.populateContentItem(request, contentStore, result, result);
        return this.createModel(result);
    }

    private void populateContentItem(HttpServletRequest request, ContentStore contentStore, ContentItem contentItem, ContentItem result) throws ContentStoreException, MalformedURLException {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        SpaceUtil.populateContentItem(ContentItemController.getBaseURL(request), result, contentItem.getSpaceId(), contentItem.getContentId(), contentStore, auth);
        String primaryStorageProviderId = this.contentStoreManager.getPrimaryContentStore().getStoreId();
        boolean primary = contentItem.getStoreId().equals(primaryStorageProviderId);
        result.setPrimaryStorageProvider(primary);
    }

    public static String getBaseURL(HttpServletRequest request) throws MalformedURLException {
        URL url = new URL(request.getRequestURL().toString());
        int port = url.getPort();
        String baseURL = url.getProtocol() + "://" + url.getHost() + ":" + (port > 0 && port != 80 ? Integer.valueOf(url.getPort()) : "") + request.getContextPath();
        return baseURL;
    }

    private ModelAndView createModel(ContentItem ci) {
        return new ModelAndView("jsonView", "contentItem", (Object)ci);
    }

    protected ContentStore getContentStore(ContentItem contentItem) throws ContentStoreException {
        return this.contentStoreManager.getContentStore(contentItem.getStoreId());
    }

    protected S3TaskClient getTaskClient(ContentItem contentItem) throws ContentStoreException {
        return this.taskClientManager.get(contentItem.getStoreId());
    }
}

