/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.duradmin.spaces.controller;

import java.io.File;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.fileupload.ProgressListener;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.duracloud.client.ContentStore;
import org.duracloud.common.util.IOUtil;
import org.duracloud.duradmin.domain.ContentItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentItemUploadTask
implements Comparable,
ProgressListener {
    Logger log = LoggerFactory.getLogger(ContentItemUploadTask.class);
    private ContentItem contentItem;
    private ContentStore contentStore;
    private long totalBytes = 0L;
    private long bytesRead = 0L;
    private String username;
    private Date startDate = null;
    private InputStream stream = null;

    public ContentItemUploadTask(ContentItem contentItem, ContentStore contentStore, InputStream stream, String username) throws Exception {
        this.stream = stream;
        this.contentItem = contentItem;
        this.contentStore = contentStore;
        this.username = username;
        this.totalBytes = -1L;
        this.log.info("new task created for {} by {}", (Object)contentItem, (Object)username);
    }

    public void execute() throws Exception {
        File tmpFile = null;
        InputStream tmpStream = null;
        try {
            this.log.info("executing file upload: {}", (Object)this.contentItem);
            this.startDate = new Date();
            tmpFile = IOUtil.writeStreamToFile((InputStream)this.stream);
            tmpStream = IOUtil.getFileStream((File)tmpFile);
            this.contentStore.addContent(this.contentItem.getSpaceId(), this.contentItem.getContentId(), tmpStream, tmpFile.length(), this.contentItem.getContentMimetype(), null, null);
            this.log.info("file upload completed successfully: {}", (Object)this.contentItem);
        }
        catch (Exception ex) {
            try {
                this.log.error("failed to upload content item: {}, bytesRead={}, totalBytes={},  message: {}", new Object[]{this.contentItem, this.bytesRead, this.totalBytes, ex.getMessage()});
                ex.printStackTrace();
                throw ex;
            }
            catch (Throwable throwable) {
                FileUtils.deleteQuietly(tmpFile);
                IOUtils.closeQuietly(tmpStream);
                throw throwable;
            }
        }
        FileUtils.deleteQuietly((File)tmpFile);
        IOUtils.closeQuietly((InputStream)tmpStream);
    }

    public void update(long pBytesRead, long pContentLength, int pItems) {
        this.bytesRead = pBytesRead;
        this.totalBytes = pContentLength;
        this.log.debug("updating progress: bytesRead = {}, totalBytes = {}", (Object)this.bytesRead, (Object)this.totalBytes);
    }

    public String getId() {
        return this.contentItem.getStoreId() + "/" + this.contentItem.getSpaceId() + "/" + this.contentItem.getContentId();
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("bytesRead", String.valueOf(this.bytesRead));
        map.put("totalBytes", String.valueOf(this.totalBytes));
        map.put("contentId", this.contentItem.getContentId());
        map.put("spaceId", this.contentItem.getSpaceId());
        map.put("storeId", this.contentItem.getStoreId());
        return map;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public int compareTo(Object o) {
        ContentItemUploadTask other = (ContentItemUploadTask)o;
        return this.getStartDate().compareTo(other.getStartDate());
    }

    public String getUsername() {
        return this.username;
    }

    public String toString() {
        return "{startDate: " + this.startDate + ", bytesRead: " + this.bytesRead + ", totalBytes: " + this.totalBytes + ", storeId: " + this.contentItem.getStoreId() + ", spaceId: " + this.contentItem.getSpaceId() + ", contentId: " + this.contentItem.getContentId() + "}";
    }
}

