/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.duradmin.config;

import java.util.Properties;
import org.duracloud.common.rest.DuraCloudRequestContextUtil;
import org.duracloud.common.util.ApplicationConfig;
import org.duracloud.duradmin.domain.AdminInit;

public class DuradminConfig
extends ApplicationConfig {
    private static AdminInit config = null;
    private static String DURADMIN_PROPERTIES_NAME = "duradmin.properties";
    private static String configFileName;
    private static boolean initialized;
    public static DuraCloudRequestContextUtil contextUtil;

    private static Properties getProps() {
        return ApplicationConfig.getPropsFromResource((String)DuradminConfig.getConfigFileName());
    }

    public static String getPropsHost() {
        return DuradminConfig.getProps().getProperty("host");
    }

    public static String getPropsPort() {
        return DuradminConfig.getProps().getProperty("port");
    }

    public static String getPropsDuraStoreContext() {
        return DuradminConfig.getProps().getProperty("durastoreContext", "durastore");
    }

    public static Boolean isPropsMillDbEnabled() {
        return Boolean.valueOf(DuradminConfig.getProps().getProperty("millDbEnabled", "true"));
    }

    public static void setConfigFileName(String name) {
        configFileName = name;
    }

    public static String getConfigFileName() {
        if (configFileName == null) {
            configFileName = DURADMIN_PROPERTIES_NAME;
        }
        return configFileName;
    }

    public static void setConfig(AdminInit init) {
        config = init;
        initialized = true;
    }

    public static boolean isInitialized() {
        return initialized;
    }

    public static String getDuraStoreHost() {
        return contextUtil.getHost();
    }

    public static String getDuraStorePort() {
        return contextUtil.getPort() + "";
    }

    public static String getDuraStoreContext() {
        DuradminConfig.checkInitialized();
        return DuradminConfig.getPropsDuraStoreContext();
    }

    public static boolean isMillDbEnabled() {
        DuradminConfig.checkInitialized();
        return config.isMillDbEnabled();
    }

    public String getAmaUrl() {
        DuradminConfig.checkInitialized();
        return config.getAmaUrl();
    }

    private static void checkInitialized() {
        if (config == null) {
            DuradminConfig.initFromProperties();
        }
    }

    private static void initFromProperties() {
        config = new AdminInit();
        config.setAmaUrl(null);
        config.setMillDbEnabled(DuradminConfig.isPropsMillDbEnabled());
    }

    static {
        initialized = false;
        contextUtil = new DuraCloudRequestContextUtil();
    }
}

