/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.duradmin.spaces.controller;

import org.duracloud.client.ContentStore;
import org.duracloud.client.ContentStoreManager;
import org.duracloud.client.task.S3TaskClientImpl;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.duracloud.error.ContentStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/spaces/mediastreamer"})
public class MediaStreamingTaskController {
    protected static final String STREAMING_ENABLED_KEY = "streamingEnabled";
    protected final Logger log = LoggerFactory.getLogger(MediaStreamingTaskController.class);
    private ContentStoreManager contentStoreManager;

    @Autowired
    public MediaStreamingTaskController(ContentStoreManager contentStoreManager) {
        this.contentStoreManager = contentStoreManager;
    }

    @RequestMapping(method={RequestMethod.POST})
    public ModelAndView post(@RequestParam(required=true) String storeId, @RequestParam(required=true) String spaceId, @RequestParam(required=true) boolean enable) throws Exception {
        try {
            ContentStore store = this.contentStoreManager.getContentStore(storeId);
            S3TaskClientImpl taskClient = new S3TaskClientImpl(store);
            if (enable) {
                try {
                    taskClient.enableStreaming(spaceId, false);
                }
                catch (ContentStoreException e) {
                    this.log.warn("failed to enable streaming on space " + spaceId + ": due to " + e.getMessage(), (Throwable)e);
                    this.log.info("attempting to enable secure streaming.");
                    taskClient.enableStreaming(spaceId, true);
                    this.log.info("successfully enabled secure streaming.");
                }
            } else {
                taskClient.disableStreaming(spaceId);
            }
            this.log.info("successfully " + (enable ? "enabled" : "disabled") + " the stream service for space (" + spaceId + ") on storage provider (" + storeId + ")");
            ModelAndView mav = new ModelAndView("jsonView", STREAMING_ENABLED_KEY, (Object)enable);
            return mav;
        }
        catch (Exception ex) {
            throw new DuraCloudRuntimeException((Throwable)ex);
        }
    }
}

