/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.io;

import java.io.IOException;
import java.io.InputStream;

public class ByteCountingInputStream
extends InputStream {
    private InputStream is;
    private long bytesRead = 0L;

    public ByteCountingInputStream(InputStream is) {
        this.is = is;
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    @Override
    public int available() throws IOException {
        return this.is.available();
    }

    private void count(int bytes) {
        if (bytes > 0) {
            this.bytesRead += (long)bytes;
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        int read = this.is.read(b);
        this.count(read);
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = this.is.read(b, off, len);
        this.count(read);
        return read;
    }

    @Override
    public int read() throws IOException {
        int read = this.is.read();
        this.count(read);
        return read;
    }

    @Override
    public long skip(long n) throws IOException {
        return this.is.skip(n);
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.is.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.is.markSupported();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.is.reset();
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }
}

