/*
 * Decompiled with CFR 0.152.
 */
package org.swordapp.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Serializer;
import org.swordapp.server.SwordConfiguration;
import org.swordapp.server.SwordServerException;
import org.swordapp.server.UriRegistry;

public class ErrorDocument {
    private String errorUri = null;
    private Map<String, Integer> errorCodes = new HashMap();
    private String summary = null;
    private String verboseDescription = null;
    private int status;

    public ErrorDocument(String errorUri) {
        this(errorUri, -1, null, null);
    }

    public ErrorDocument(String errorUri, int status) {
        this(errorUri, status, null, null);
    }

    public ErrorDocument(String errorUri, String verboseDescription) {
        this(errorUri, -1, null, verboseDescription);
    }

    public ErrorDocument(String errorUri, int status, String verboseDescription) {
        this(errorUri, status, null, verboseDescription);
    }

    public ErrorDocument(String errorUri, int status, String summary, String verboseDescription) {
        this.errorCodes.put(UriRegistry.ERROR_BAD_REQUEST, 400);
        this.errorCodes.put(UriRegistry.ERROR_CHECKSUM_MISMATCH, 412);
        this.errorCodes.put(UriRegistry.ERROR_CONTENT, 415);
        this.errorCodes.put(UriRegistry.ERROR_MEDIATION_NOT_ALLOWED, 412);
        this.errorCodes.put(UriRegistry.ERROR_METHOD_NOT_ALLOWED, 405);
        this.errorCodes.put(UriRegistry.ERROR_TARGET_OWNER_UNKNOWN, 403);
        this.errorCodes.put(UriRegistry.ERROR_MAX_UPLOAD_SIZE_EXCEEDED, 413);
        this.errorUri = errorUri;
        this.summary = summary;
        this.verboseDescription = verboseDescription;
        this.status = status;
    }

    public int getStatus() {
        if (this.status > -1) {
            return this.status;
        }
        if (this.errorUri != null && this.errorCodes.containsKey(this.errorUri)) {
            return (Integer)this.errorCodes.get(this.errorUri);
        }
        return 400;
    }

    public void writeTo(Writer out, SwordConfiguration config) throws IOException, SwordServerException {
        Element error = new Element("sword:error", UriRegistry.SWORD_TERMS_NAMESPACE);
        error.addAttribute(new Attribute("href", this.errorUri));
        Element title = new Element("atom:title", UriRegistry.ATOM_NAMESPACE);
        title.appendChild("ERROR");
        Element updates = new Element("atom:updated", UriRegistry.ATOM_NAMESPACE);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        updates.appendChild(sdf.format(new Date()));
        Element generator = new Element("atom:generator", UriRegistry.ATOM_NAMESPACE);
        generator.addAttribute(new Attribute("uri", config.generator()));
        generator.addAttribute(new Attribute("version", config.generatorVersion()));
        if (config.administratorEmail() != null) {
            generator.appendChild(config.administratorEmail());
        }
        Element treatment = new Element("sword:treatment", UriRegistry.SWORD_TERMS_NAMESPACE);
        treatment.appendChild("Processing failed");
        error.appendChild((Node)title);
        error.appendChild((Node)updates);
        error.appendChild((Node)generator);
        error.appendChild((Node)treatment);
        if (this.summary != null) {
            Element summary = new Element("atom:summary", UriRegistry.ATOM_NAMESPACE);
            summary.appendChild(this.summary);
            error.appendChild((Node)summary);
        }
        if (this.verboseDescription != null) {
            Element vd = new Element("sword:verboseDescription", UriRegistry.SWORD_TERMS_NAMESPACE);
            vd.appendChild(this.verboseDescription);
            error.appendChild((Node)vd);
        }
        String alternate = config.getAlternateUrl();
        String altContentType = config.getAlternateUrlContentType();
        if (alternate != null && !"".equals(alternate)) {
            Element altLink = new Element("atom:link", UriRegistry.ATOM_NAMESPACE);
            altLink.addAttribute(new Attribute("rel", "alternate"));
            if (altContentType != null && !"".equals(altContentType)) {
                altLink.addAttribute(new Attribute("type", altContentType));
            }
            altLink.addAttribute(new Attribute("href", alternate));
            error.appendChild((Node)altLink);
        }
        try {
            Document doc = new Document(error);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Serializer serializer = new Serializer((OutputStream)baos, "ISO-8859-1");
            serializer.write(doc);
            out.write(baos.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new SwordServerException((Throwable)e);
        }
    }
}

