/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword2;

import java.io.IOException;
import java.sql.SQLException;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.Context;
import org.dspace.sword2.AbstractSwordContentIngester;
import org.dspace.sword2.DSpaceSwordException;
import org.dspace.sword2.DepositResult;
import org.dspace.sword2.VerboseDescription;
import org.swordapp.server.Deposit;
import org.swordapp.server.SwordAuthException;
import org.swordapp.server.SwordError;
import org.swordapp.server.SwordServerException;

public class BinaryContentIngester
extends AbstractSwordContentIngester {
    public DepositResult ingestToCollection(Context context, Deposit deposit, Collection collection, VerboseDescription verboseDescription, DepositResult result) throws DSpaceSwordException, SwordError, SwordAuthException, SwordServerException {
        try {
            Item item = null;
            WorkspaceItem wsi = null;
            if (result != null) {
                item = result.getItem();
            } else {
                result = new DepositResult();
            }
            if (item == null) {
                wsi = WorkspaceItem.create((Context)context, (Collection)collection, (boolean)true);
                item = wsi.getItem();
            }
            Bitstream bs = item.createSingleBitstream(deposit.getInputStream());
            BitstreamFormat format = this.getFormat(context, deposit.getFilename());
            bs.setName(deposit.getFilename());
            bs.setFormat(format);
            bs.update();
            item.addMetadata("dc", "title", null, null, "Untitled: " + deposit.getFilename());
            item.addMetadata("dc", "description", null, null, "Zip file deposted by SWORD without accompanying metadata");
            this.setUpdatedDate(item, verboseDescription);
            this.setSlug(item, deposit.getSlug(), verboseDescription);
            context.turnOffAuthorisationSystem();
            item.update();
            context.restoreAuthSystemState();
            verboseDescription.append("Ingest successful");
            verboseDescription.append("Item created with internal identifier: " + item.getID());
            result.setItem(item);
            result.setTreatment(this.getTreatment());
            result.setOriginalDeposit(bs);
            return result;
        }
        catch (AuthorizeException e) {
            throw new SwordAuthException((Throwable)e);
        }
        catch (SQLException e) {
            throw new DSpaceSwordException((Throwable)e);
        }
        catch (IOException e) {
            throw new DSpaceSwordException((Throwable)e);
        }
    }

    public DepositResult ingestToItem(Context context, Deposit deposit, Item item, VerboseDescription verboseDescription, DepositResult result) throws DSpaceSwordException, SwordError, SwordAuthException, SwordServerException {
        try {
            if (result == null) {
                result = new DepositResult();
            }
            result.setItem(item);
            Bundle[] originals = item.getBundles("ORIGINAL");
            Bundle original = null;
            original = originals.length > 0 ? originals[0] : item.createBundle("ORIGINAL");
            Bitstream bs = original.createBitstream(deposit.getInputStream());
            BitstreamFormat format = this.getFormat(context, deposit.getFilename());
            bs.setFormat(format);
            bs.setName(deposit.getFilename());
            bs.update();
            this.setUpdatedDate(item, verboseDescription);
            context.turnOffAuthorisationSystem();
            item.update();
            context.restoreAuthSystemState();
            verboseDescription.append("ingest successful");
            result.setItem(item);
            result.setTreatment(this.getTreatment());
            result.setOriginalDeposit(bs);
            return result;
        }
        catch (AuthorizeException e) {
            throw new SwordAuthException((Throwable)e);
        }
        catch (SQLException e) {
            throw new DSpaceSwordException((Throwable)e);
        }
        catch (IOException e) {
            throw new DSpaceSwordException((Throwable)e);
        }
    }

    private String getTreatment() throws DSpaceSwordException {
        return "The package has been ingested and unpacked into the item.  Template metadata for the collection has been used, and a default title with the name of the file has been set";
    }
}

