/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword2;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.sword2.DSpaceSwordAPI;
import org.dspace.sword2.DSpaceSwordException;
import org.dspace.sword2.DepositResult;
import org.dspace.sword2.ReceiptGenerator;
import org.dspace.sword2.SwordAuthenticator;
import org.dspace.sword2.SwordConfigurationDSpace;
import org.dspace.sword2.SwordContentIngester;
import org.dspace.sword2.SwordContext;
import org.dspace.sword2.SwordDisseminatorFactory;
import org.dspace.sword2.SwordEntryIngester;
import org.dspace.sword2.SwordIngesterFactory;
import org.dspace.sword2.SwordStatementDisseminator;
import org.dspace.sword2.SwordUrlManager;
import org.dspace.sword2.VerboseDescription;
import org.dspace.sword2.VersionManager;
import org.dspace.sword2.WorkflowManager;
import org.dspace.sword2.WorkflowManagerFactory;
import org.dspace.sword2.WorkflowTools;
import org.swordapp.server.AuthCredentials;
import org.swordapp.server.ContainerManager;
import org.swordapp.server.Deposit;
import org.swordapp.server.DepositReceipt;
import org.swordapp.server.SwordAuthException;
import org.swordapp.server.SwordConfiguration;
import org.swordapp.server.SwordError;
import org.swordapp.server.SwordServerException;

public class ContainerManagerDSpace
extends DSpaceSwordAPI
implements ContainerManager {
    private static Logger log = Logger.getLogger(ContainerManagerDSpace.class);
    private VerboseDescription verboseDescription = new VerboseDescription();

    public boolean isStatementRequest(String editIRI, Map<String, String> accept, AuthCredentials authCredentials, SwordConfiguration swordConfig) throws SwordError, SwordServerException, SwordAuthException {
        SwordContext sc = null;
        try {
            sc = this.noAuthContext();
            SwordConfigurationDSpace config = (SwordConfigurationDSpace)swordConfig;
            Context context = sc.getContext();
            String acceptContentType = this.getHeader(accept, "Accept", null);
            TreeMap analysed = this.analyseAccept(acceptContentType);
            SwordStatementDisseminator disseminator = null;
            try {
                disseminator = SwordDisseminatorFactory.getStatementInstance((Map)analysed);
            }
            catch (SwordError swordError) {
                boolean bl = false;
                if (sc != null) {
                    sc.abort();
                }
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (DSpaceSwordException e) {
            log.error((Object)"caught exception:", (Throwable)e);
            throw new SwordServerException("There was a problem determining the request type", (Throwable)e);
        }
        finally {
            if (sc != null) {
                sc.abort();
            }
        }
    }

    public DepositReceipt getEntry(String editIRI, Map<String, String> accept, AuthCredentials authCredentials, SwordConfiguration swordConfig) throws SwordServerException, SwordError, SwordAuthException {
        SwordContext sc = null;
        try {
            SwordConfigurationDSpace config = (SwordConfigurationDSpace)swordConfig;
            sc = this.doAuth(authCredentials);
            Context context = sc.getContext();
            SwordUrlManager urlManager = config.getUrlManager(context, config);
            Item item = urlManager.getItem(context, editIRI);
            if (item == null) {
                throw new SwordError(404);
            }
            AuthorizeManager.authorizeAction((Context)context, (DSpaceObject)item, (int)0);
            ReceiptGenerator genny = new ReceiptGenerator();
            DepositReceipt receipt = genny.createReceipt(context, item, config);
            sc.abort();
            DepositReceipt depositReceipt = receipt;
            return depositReceipt;
        }
        catch (AuthorizeException e) {
            throw new SwordAuthException();
        }
        catch (SQLException e) {
            throw new SwordServerException((Throwable)e);
        }
        catch (DSpaceSwordException e) {
            throw new SwordServerException((Throwable)e);
        }
        finally {
            if (sc != null) {
                sc.abort();
            }
        }
    }

    public DepositReceipt replaceMetadata(String editIRI, Deposit deposit, AuthCredentials authCredentials, SwordConfiguration swordConfig) throws SwordError, SwordServerException, SwordAuthException {
        Date start = new Date();
        this.verboseDescription.append("Initialising verbose replace of metadata");
        SwordContext sc = null;
        SwordConfigurationDSpace config = (SwordConfigurationDSpace)swordConfig;
        try {
            Item item;
            sc = this.doAuth(authCredentials);
            Context context = sc.getContext();
            if (log.isDebugEnabled()) {
                log.debug((Object)LogManager.getHeader((Context)context, (String)"sword_replace", (String)""));
            }
            if ((item = this.getDSpaceTarget(context, editIRI, config)) == null) {
                throw new SwordError(404);
            }
            WorkflowManager wfm = WorkflowManagerFactory.getInstance();
            wfm.replaceMetadata(context, item);
            SwordAuthenticator auth = new SwordAuthenticator();
            if (!auth.canSubmit(sc, (DSpaceObject)item, this.verboseDescription)) {
                String oboEmail = "none";
                if (sc.getOnBehalfOf() != null) {
                    oboEmail = sc.getOnBehalfOf().getEmail();
                }
                log.info((Object)LogManager.getHeader((Context)context, (String)"replace_failed_authorisation", (String)("user=" + sc.getAuthenticated().getEmail() + ",on_behalf_of=" + oboEmail)));
                throw new SwordAuthException("Cannot replace the given item with this context");
            }
            this.verboseDescription.append("Authenticated user: " + sc.getAuthenticated().getEmail());
            if (sc.getOnBehalfOf() != null) {
                this.verboseDescription.append("Depositing on behalf of: " + sc.getOnBehalfOf().getEmail());
            }
            DepositResult result = null;
            try {
                result = this.doReplaceMetadata(sc, item, deposit, authCredentials, config);
            }
            catch (DSpaceSwordException e) {
                if (config.isKeepPackageOnFailedIngest()) {
                    try {
                        this.storeEntryAsFile(deposit, authCredentials, config);
                    }
                    catch (IOException e2) {
                        log.warn((Object)("Unable to store SWORD entry as file: " + (Object)((Object)e)));
                    }
                }
                throw e;
            }
            catch (SwordError e) {
                if (config.isKeepPackageOnFailedIngest()) {
                    try {
                        this.storeEntryAsFile(deposit, authCredentials, config);
                    }
                    catch (IOException e2) {
                        log.warn((Object)("Unable to store SWORD entry as file: " + (Object)((Object)e)));
                    }
                }
                throw e;
            }
            wfm.resolveState(context, deposit, result, this.verboseDescription);
            ReceiptGenerator genny = new ReceiptGenerator();
            DepositReceipt receipt = genny.createReceipt(context, result, config);
            Date finish = new Date();
            long delta = finish.getTime() - start.getTime();
            this.verboseDescription.append("Total time for deposit processing: " + delta + " ms");
            this.addVerboseDescription(receipt, this.verboseDescription);
            sc.commit();
            DepositReceipt depositReceipt = receipt;
            return depositReceipt;
        }
        catch (DSpaceSwordException e) {
            log.error((Object)"caught exception:", (Throwable)e);
            throw new SwordServerException("There was a problem depositing the item", (Throwable)e);
        }
        finally {
            if (sc != null) {
                sc.abort();
            }
        }
    }

    public DepositReceipt replaceMetadataAndMediaResource(String editIRI, Deposit deposit, AuthCredentials authCredentials, SwordConfiguration swordConfig) throws SwordError, SwordServerException, SwordAuthException {
        Date start = new Date();
        this.verboseDescription.append("Initialising verbose multipart replace");
        SwordContext sc = null;
        SwordConfigurationDSpace config = (SwordConfigurationDSpace)swordConfig;
        try {
            Item item;
            sc = this.doAuth(authCredentials);
            Context context = sc.getContext();
            if (log.isDebugEnabled()) {
                log.debug((Object)LogManager.getHeader((Context)context, (String)"sword_create_new", (String)""));
            }
            if ((item = this.getDSpaceTarget(context, editIRI, config)) == null) {
                throw new SwordError(404);
            }
            WorkflowManager wfm = WorkflowManagerFactory.getInstance();
            wfm.replaceMetadataAndMediaResource(context, item);
            SwordAuthenticator auth = new SwordAuthenticator();
            if (!auth.canSubmit(sc, (DSpaceObject)item, this.verboseDescription)) {
                String oboEmail = "none";
                if (sc.getOnBehalfOf() != null) {
                    oboEmail = sc.getOnBehalfOf().getEmail();
                }
                log.info((Object)LogManager.getHeader((Context)context, (String)"deposit_failed_authorisation", (String)("user=" + sc.getAuthenticated().getEmail() + ",on_behalf_of=" + oboEmail)));
                throw new SwordAuthException("Cannot submit to the given collection with this context");
            }
            this.verboseDescription.append("Authenticated user: " + sc.getAuthenticated().getEmail());
            if (sc.getOnBehalfOf() != null) {
                this.verboseDescription.append("Depositing on behalf of: " + sc.getOnBehalfOf().getEmail());
            }
            DepositResult result = null;
            try {
                result = this.replaceFromMultipart(sc, item, deposit, authCredentials, config);
            }
            catch (DSpaceSwordException e) {
                if (config.isKeepPackageOnFailedIngest()) {
                    try {
                        this.storePackageAsFile(deposit, authCredentials, config);
                        this.storeEntryAsFile(deposit, authCredentials, config);
                    }
                    catch (IOException e2) {
                        log.warn((Object)("Unable to store SWORD package as file: " + (Object)((Object)e)));
                    }
                }
                throw e;
            }
            catch (SwordError e) {
                if (config.isKeepPackageOnFailedIngest()) {
                    try {
                        this.storePackageAsFile(deposit, authCredentials, config);
                        this.storeEntryAsFile(deposit, authCredentials, config);
                    }
                    catch (IOException e2) {
                        log.warn((Object)("Unable to store SWORD package as file: " + (Object)((Object)e)));
                    }
                }
                throw e;
            }
            wfm.resolveState(context, deposit, result, this.verboseDescription);
            ReceiptGenerator genny = new ReceiptGenerator();
            DepositReceipt receipt = genny.createReceipt(context, result, config);
            Date finish = new Date();
            long delta = finish.getTime() - start.getTime();
            this.verboseDescription.append("Total time for deposit processing: " + delta + " ms");
            this.addVerboseDescription(receipt, this.verboseDescription);
            sc.commit();
            DepositReceipt depositReceipt = receipt;
            return depositReceipt;
        }
        catch (DSpaceSwordException e) {
            log.error((Object)"caught exception:", (Throwable)e);
            throw new SwordServerException("There was a problem depositing the item", (Throwable)e);
        }
        finally {
            if (sc != null) {
                sc.abort();
            }
        }
    }

    public DepositReceipt addMetadataAndResources(String s, Deposit deposit, AuthCredentials authCredentials, SwordConfiguration config) throws SwordError, SwordServerException {
        return null;
    }

    public DepositReceipt addMetadata(String editIRI, Deposit deposit, AuthCredentials authCredentials, SwordConfiguration swordConfig) throws SwordError, SwordServerException, SwordAuthException {
        Date start = new Date();
        this.verboseDescription.append("Initialising verbose replace of metadata");
        SwordContext sc = null;
        SwordConfigurationDSpace config = (SwordConfigurationDSpace)swordConfig;
        try {
            Item item;
            sc = this.doAuth(authCredentials);
            Context context = sc.getContext();
            if (log.isDebugEnabled()) {
                log.debug((Object)LogManager.getHeader((Context)context, (String)"sword_replace", (String)""));
            }
            if ((item = this.getDSpaceTarget(context, editIRI, config)) == null) {
                throw new SwordError(404);
            }
            WorkflowManager wfm = WorkflowManagerFactory.getInstance();
            wfm.addMetadata(context, item);
            SwordAuthenticator auth = new SwordAuthenticator();
            if (!auth.canSubmit(sc, (DSpaceObject)item, this.verboseDescription)) {
                String oboEmail = "none";
                if (sc.getOnBehalfOf() != null) {
                    oboEmail = sc.getOnBehalfOf().getEmail();
                }
                log.info((Object)LogManager.getHeader((Context)context, (String)"replace_failed_authorisation", (String)("user=" + sc.getAuthenticated().getEmail() + ",on_behalf_of=" + oboEmail)));
                throw new SwordAuthException("Cannot replace the given item with this context");
            }
            this.verboseDescription.append("Authenticated user: " + sc.getAuthenticated().getEmail());
            if (sc.getOnBehalfOf() != null) {
                this.verboseDescription.append("Depositing on behalf of: " + sc.getOnBehalfOf().getEmail());
            }
            DepositResult result = null;
            try {
                result = this.doAddMetadata(sc, item, deposit, authCredentials, config);
            }
            catch (DSpaceSwordException e) {
                if (config.isKeepPackageOnFailedIngest()) {
                    try {
                        this.storeEntryAsFile(deposit, authCredentials, config);
                    }
                    catch (IOException e2) {
                        log.warn((Object)("Unable to store SWORD entry as file: " + (Object)((Object)e)));
                    }
                }
                throw e;
            }
            catch (SwordError e) {
                if (config.isKeepPackageOnFailedIngest()) {
                    try {
                        this.storeEntryAsFile(deposit, authCredentials, config);
                    }
                    catch (IOException e2) {
                        log.warn((Object)("Unable to store SWORD entry as file: " + (Object)((Object)e)));
                    }
                }
                throw e;
            }
            wfm.resolveState(context, deposit, result, this.verboseDescription);
            ReceiptGenerator genny = new ReceiptGenerator();
            DepositReceipt receipt = genny.createReceipt(context, result, config);
            Date finish = new Date();
            long delta = finish.getTime() - start.getTime();
            this.verboseDescription.append("Total time for deposit processing: " + delta + " ms");
            this.addVerboseDescription(receipt, this.verboseDescription);
            sc.commit();
            DepositReceipt depositReceipt = receipt;
            return depositReceipt;
        }
        catch (DSpaceSwordException e) {
            log.error((Object)"caught exception:", (Throwable)e);
            throw new SwordServerException("There was a problem depositing the item", (Throwable)e);
        }
        finally {
            if (sc != null) {
                sc.abort();
            }
        }
    }

    public DepositReceipt addResources(String s, Deposit deposit, AuthCredentials authCredentials, SwordConfiguration config) throws SwordError, SwordServerException {
        return null;
    }

    public void deleteContainer(String editIRI, AuthCredentials authCredentials, SwordConfiguration swordConfig) throws SwordError, SwordServerException, SwordAuthException {
        Date start = new Date();
        this.verboseDescription.append("Initialising verbose container delete");
        SwordContext sc = null;
        SwordConfigurationDSpace config = (SwordConfigurationDSpace)swordConfig;
        try {
            Item item;
            sc = this.doAuth(authCredentials);
            Context context = sc.getContext();
            if (log.isDebugEnabled()) {
                log.debug((Object)LogManager.getHeader((Context)context, (String)"sword_delete", (String)""));
            }
            if ((item = this.getDSpaceTarget(context, editIRI, config)) == null) {
                throw new SwordError(404);
            }
            WorkflowManager wfm = WorkflowManagerFactory.getInstance();
            wfm.deleteItem(context, item);
            SwordAuthenticator auth = new SwordAuthenticator();
            if (!auth.canSubmit(sc, (DSpaceObject)item, this.verboseDescription)) {
                String oboEmail = "none";
                if (sc.getOnBehalfOf() != null) {
                    oboEmail = sc.getOnBehalfOf().getEmail();
                }
                log.info((Object)LogManager.getHeader((Context)context, (String)"replace_failed_authorisation", (String)("user=" + sc.getAuthenticated().getEmail() + ",on_behalf_of=" + oboEmail)));
                throw new SwordAuthException("Cannot delete the given item with this context");
            }
            this.verboseDescription.append("Authenticated user: " + sc.getAuthenticated().getEmail());
            if (sc.getOnBehalfOf() != null) {
                this.verboseDescription.append("Depositing on behalf of: " + sc.getOnBehalfOf().getEmail());
            }
            this.doContainerDelete(sc, item, authCredentials, config);
            Date finish = new Date();
            long delta = finish.getTime() - start.getTime();
            this.verboseDescription.append("Total time for deposit processing: " + delta + " ms");
            sc.commit();
        }
        catch (DSpaceSwordException e) {
            log.error((Object)"caught exception:", (Throwable)e);
            throw new SwordServerException("There was a problem depositing the item", (Throwable)e);
        }
        finally {
            if (sc != null) {
                sc.abort();
            }
        }
    }

    public DepositReceipt useHeaders(String editIRI, Deposit deposit, AuthCredentials authCredentials, SwordConfiguration swordConfig) throws SwordError, SwordServerException, SwordAuthException {
        Date start = new Date();
        this.verboseDescription.append("Initialising verbose empty request (headers only)");
        SwordContext sc = null;
        SwordConfigurationDSpace config = (SwordConfigurationDSpace)swordConfig;
        try {
            Item item;
            sc = this.doAuth(authCredentials);
            Context context = sc.getContext();
            if (log.isDebugEnabled()) {
                log.debug((Object)LogManager.getHeader((Context)context, (String)"sword_modify_by_headers", (String)""));
            }
            if ((item = this.getDSpaceTarget(context, editIRI, config)) == null) {
                throw new SwordError(404);
            }
            WorkflowManager wfm = WorkflowManagerFactory.getInstance();
            wfm.modifyState(context, item);
            SwordAuthenticator auth = new SwordAuthenticator();
            if (!auth.canSubmit(sc, (DSpaceObject)item, this.verboseDescription)) {
                String oboEmail = "none";
                if (sc.getOnBehalfOf() != null) {
                    oboEmail = sc.getOnBehalfOf().getEmail();
                }
                log.info((Object)LogManager.getHeader((Context)context, (String)"modify_failed_authorisation", (String)("user=" + sc.getAuthenticated().getEmail() + ",on_behalf_of=" + oboEmail)));
                throw new SwordAuthException("Cannot modify the given item with this context");
            }
            this.verboseDescription.append("Authenticated user: " + sc.getAuthenticated().getEmail());
            if (sc.getOnBehalfOf() != null) {
                this.verboseDescription.append("Modifying on behalf of: " + sc.getOnBehalfOf().getEmail());
            }
            DepositResult result = new DepositResult();
            result.setItem(item);
            wfm.resolveState(context, deposit, result, this.verboseDescription);
            ReceiptGenerator genny = new ReceiptGenerator();
            DepositReceipt receipt = genny.createReceipt(context, item, config);
            Date finish = new Date();
            long delta = finish.getTime() - start.getTime();
            this.verboseDescription.append("Total time for modify processing: " + delta + " ms");
            this.addVerboseDescription(receipt, this.verboseDescription);
            sc.commit();
            DepositReceipt depositReceipt = receipt;
            return depositReceipt;
        }
        catch (DSpaceSwordException e) {
            log.error((Object)"caught exception:", (Throwable)e);
            throw new SwordServerException("There was a problem depositing the item", (Throwable)e);
        }
        finally {
            if (sc != null) {
                sc.abort();
            }
        }
    }

    private DepositResult replaceFromMultipart(SwordContext swordContext, Item item, Deposit deposit, AuthCredentials authCredentials, SwordConfigurationDSpace swordConfig) throws DSpaceSwordException, SwordError, SwordAuthException, SwordServerException {
        DepositResult result;
        Context context = swordContext.getContext();
        SwordUrlManager urlManager = swordConfig.getUrlManager(swordContext.getContext(), swordConfig);
        this.isAcceptable(swordConfig, context, deposit, (DSpaceObject)item);
        SwordContentIngester sci = SwordIngesterFactory.getContentInstance((Context)context, (Deposit)deposit, (DSpaceObject)item);
        this.verboseDescription.append("Loaded content ingester: " + sci.getClass().getName());
        SwordEntryIngester sei = SwordIngesterFactory.getEntryInstance((Context)context, (Deposit)deposit, (DSpaceObject)item);
        this.verboseDescription.append("Loaded entry ingester: " + sei.getClass().getName());
        try {
            VersionManager vm = new VersionManager();
            vm.removeBundle(item, "ORIGINAL");
        }
        catch (SQLException e) {
            throw new DSpaceSwordException((Throwable)e);
        }
        catch (AuthorizeException e) {
            throw new SwordAuthException((Throwable)e);
        }
        catch (IOException e) {
            throw new DSpaceSwordException((Throwable)e);
        }
        if (swordConfig.isEntryFirst()) {
            result = sei.ingest(context, deposit, (DSpaceObject)item, this.verboseDescription, null, true);
            result = sci.ingest(context, deposit, (DSpaceObject)item, this.verboseDescription, result);
            this.verboseDescription.append("Archive ingest completed successfully");
        } else {
            result = sci.ingest(context, deposit, (DSpaceObject)item, this.verboseDescription, null);
            result = sei.ingest(context, deposit, (DSpaceObject)item, this.verboseDescription, result, true);
            this.verboseDescription.append("Archive ingest completed successfully");
        }
        this.storeOriginals(swordConfig, context, this.verboseDescription, deposit, result);
        return result;
    }

    private DepositResult doReplaceMetadata(SwordContext swordContext, Item item, Deposit deposit, AuthCredentials authCredentials, SwordConfigurationDSpace swordConfig) throws DSpaceSwordException, SwordError, SwordAuthException, SwordServerException {
        Context context = swordContext.getContext();
        SwordUrlManager urlManager = swordConfig.getUrlManager(swordContext.getContext(), swordConfig);
        SwordEntryIngester si = SwordIngesterFactory.getEntryInstance((Context)context, (Deposit)deposit, null);
        this.verboseDescription.append("Loaded ingester: " + si.getClass().getName());
        DepositResult result = si.ingest(context, deposit, (DSpaceObject)item, this.verboseDescription, null, true);
        this.verboseDescription.append("Replace completed successfully");
        this.storeOriginals(swordConfig, context, this.verboseDescription, deposit, result);
        return result;
    }

    protected DepositResult doAddMetadata(SwordContext swordContext, Item item, Deposit deposit, AuthCredentials authCredentials, SwordConfigurationDSpace swordConfig) throws DSpaceSwordException, SwordError, SwordAuthException, SwordServerException {
        return this.doAddMetadata(swordContext, item, deposit, authCredentials, swordConfig, null);
    }

    protected DepositResult doAddMetadata(SwordContext swordContext, Item item, Deposit deposit, AuthCredentials authCredentials, SwordConfigurationDSpace swordConfig, DepositResult result) throws DSpaceSwordException, SwordError, SwordAuthException, SwordServerException {
        if (result == null) {
            result = new DepositResult();
        }
        Context context = swordContext.getContext();
        SwordUrlManager urlManager = swordConfig.getUrlManager(swordContext.getContext(), swordConfig);
        SwordEntryIngester si = SwordIngesterFactory.getEntryInstance((Context)context, (Deposit)deposit, null);
        this.verboseDescription.append("Loaded ingester: " + si.getClass().getName());
        result = si.ingest(context, deposit, (DSpaceObject)item, this.verboseDescription, result, false);
        this.verboseDescription.append("Replace completed successfully");
        this.storeOriginals(swordConfig, context, this.verboseDescription, deposit, result);
        return result;
    }

    protected void doContainerDelete(SwordContext swordContext, Item item, AuthCredentials authCredentials, SwordConfigurationDSpace swordConfig) throws DSpaceSwordException, SwordAuthException {
        try {
            Collection[] collections;
            Context context = swordContext.getContext();
            WorkflowTools wft = new WorkflowTools();
            if (wft.isItemInWorkspace(swordContext.getContext(), item)) {
                WorkspaceItem wsi = wft.getWorkspaceItem(context, item);
                wsi.deleteAll();
            } else if (wft.isItemInWorkflow(context, item)) {
                InProgressSubmission wfi = wft.getWorkflowItem(context, item);
                wfi.deleteWrapper();
            }
            for (Collection collection : collections = item.getCollections()) {
                collection.removeItem(item);
            }
        }
        catch (SQLException e) {
            throw new DSpaceSwordException((Throwable)e);
        }
        catch (AuthorizeException e) {
            throw new SwordAuthException((Throwable)e);
        }
        catch (IOException e) {
            throw new DSpaceSwordException((Throwable)e);
        }
    }

    private Item getDSpaceTarget(Context context, String editUrl, SwordConfigurationDSpace config) throws DSpaceSwordException, SwordError {
        SwordUrlManager urlManager = config.getUrlManager(context, config);
        Item item = urlManager.getItem(context, editUrl);
        if (item == null) {
            throw new SwordError(404);
        }
        this.verboseDescription.append("Performing replace using edit-media URL: " + editUrl);
        this.verboseDescription.append("Location resolves to item with handle: " + item.getHandle());
        return item;
    }
}

