/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword2;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.dspace.authenticate.AuthenticationManager;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.ItemIterator;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.sword2.DSpaceSwordException;
import org.dspace.sword2.SwordContext;
import org.dspace.sword2.VerboseDescription;
import org.swordapp.server.AuthCredentials;
import org.swordapp.server.SwordAuthException;
import org.swordapp.server.SwordError;
import org.swordapp.server.UriRegistry;

public class SwordAuthenticator {
    private static Logger log = Logger.getLogger(SwordAuthenticator.class);

    public boolean authenticates(Context context, String un, String pw) {
        int auth = AuthenticationManager.authenticate((Context)context, (String)un, (String)pw, null, null);
        return auth == 1;
    }

    private Context constructContext() throws DSpaceSwordException {
        try {
            Context context = new Context();
            context.setExtraLogInfo("session_id=0");
            return context;
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new DSpaceSwordException("There was a problem with the database", (Throwable)e);
        }
    }

    public SwordContext authenticate(AuthCredentials auth) throws DSpaceSwordException, SwordError, SwordAuthException {
        Context context = this.constructContext();
        SwordContext sc = null;
        try {
            sc = this.authenticate(context, auth);
        }
        catch (DSpaceSwordException e) {
            if (context != null && context.isValid()) {
                context.abort();
            }
            throw e;
        }
        catch (SwordError e) {
            if (context != null && context.isValid()) {
                context.abort();
            }
            throw e;
        }
        catch (SwordAuthException e) {
            if (context != null && context.isValid()) {
                context.abort();
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (context != null && context.isValid()) {
                context.abort();
            }
            throw e;
        }
        return sc;
    }

    private SwordContext authenticate(Context context, AuthCredentials auth) throws SwordAuthException, SwordError, DSpaceSwordException {
        boolean mediated;
        String obo = auth.getOnBehalfOf();
        String un = auth.getUsername();
        String pw = auth.getPassword();
        if ("".equals(obo)) {
            obo = null;
        }
        if (!(mediated = ConfigurationManager.getBooleanProperty((String)"swordv2-server", (String)"on-behalf-of.enable")) && obo != null) {
            log.error((Object)"Attempted mediated deposit on service not configured to do so");
            throw new SwordError(UriRegistry.ERROR_MEDIATION_NOT_ALLOWED, "Mediated deposit to this service is not permitted");
        }
        log.info((Object)LogManager.getHeader((Context)context, (String)"sword_authenticate", (String)("username=" + un + ",on_behalf_of=" + obo)));
        try {
            SwordContext sc = new SwordContext();
            EPerson ep = null;
            boolean authenticated = false;
            if (this.authenticates(context, un, pw)) {
                ep = context.getCurrentUser();
                if (ep != null) {
                    authenticated = true;
                    sc.setAuthenticated(ep);
                    int[] groupIDs = AuthenticationManager.getSpecialGroups((Context)context, null);
                    for (int i = 0; i < groupIDs.length; ++i) {
                        context.setSpecialGroup(groupIDs[i]);
                        log.debug((Object)("Adding Special Group id=" + String.valueOf(groupIDs[i])));
                    }
                    sc.setAuthenticatorContext(context);
                    sc.setContext(context);
                }
                EPerson epObo = null;
                if (obo != null) {
                    epObo = EPerson.findByEmail((Context)context, (String)obo);
                    if (epObo == null) {
                        epObo = EPerson.findByNetid((Context)context, (String)obo);
                    }
                    if (epObo != null) {
                        sc.setOnBehalfOf(epObo);
                        Context oboContext = this.constructContext();
                        oboContext.setCurrentUser(epObo);
                        int[] groupIDs = AuthenticationManager.getSpecialGroups((Context)oboContext, null);
                        for (int i = 0; i < groupIDs.length; ++i) {
                            oboContext.setSpecialGroup(groupIDs[i]);
                            log.debug((Object)("Adding Special Group id=" + String.valueOf(groupIDs[i])));
                        }
                        sc.setContext(oboContext);
                    } else {
                        authenticated = false;
                        throw new SwordError(UriRegistry.ERROR_TARGET_OWNER_UNKNOWN, "unable to identify on-behalf-of user: " + obo);
                    }
                }
            }
            if (!authenticated) {
                if (ep != null) {
                    log.info((Object)LogManager.getHeader((Context)context, (String)"sword_unable_to_set_user", (String)("username=" + un)));
                    throw new SwordAuthException("Unable to authenticate with the supplied credentials");
                }
                log.info((Object)LogManager.getHeader((Context)context, (String)"sword_unable_to_set_on_behalf_of", (String)("username=" + un + ",on_behalf_of=" + obo)));
                throw new SwordAuthException("Unable to authenticate the onBehalfOf account");
            }
            return sc;
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new DSpaceSwordException("There was a problem accessing the repository user database", (Throwable)e);
        }
        catch (AuthorizeException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new SwordAuthException("There was a problem authenticating or authorising the user", (Throwable)e);
        }
    }

    public boolean canSubmit(SwordContext swordContext, DSpaceObject dso, VerboseDescription msg) throws DSpaceSwordException, SwordError {
        boolean submit = this.canSubmitTo(swordContext, dso);
        if (submit) {
            msg.append("User is authorised to submit to collection");
        } else {
            msg.append("User is not authorised to submit to collection");
        }
        return submit;
    }

    public boolean isUserAdmin(SwordContext swordContext) throws DSpaceSwordException {
        try {
            EPerson authenticated = swordContext.getAuthenticated();
            if (authenticated != null) {
                return AuthorizeManager.isAdmin((Context)swordContext.getAuthenticatorContext());
            }
            return false;
        }
        catch (SQLException e) {
            log.error((Object)"Caught exception: ", (Throwable)e);
            throw new DSpaceSwordException((Throwable)e);
        }
    }

    public boolean isOnBehalfOfAdmin(SwordContext swordContext) throws DSpaceSwordException {
        EPerson onBehalfOf = swordContext.getOnBehalfOf();
        try {
            if (onBehalfOf != null) {
                return AuthorizeManager.isAdmin((Context)swordContext.getOnBehalfOfContext());
            }
            return false;
        }
        catch (SQLException e) {
            log.error((Object)"Caught exception: ", (Throwable)e);
            throw new DSpaceSwordException((Throwable)e);
        }
    }

    public boolean isUserInGroup(SwordContext swordContext, Group group) {
        EPerson authenticated = swordContext.getAuthenticated();
        if (authenticated != null) {
            return this.isInGroup(group, authenticated);
        }
        return false;
    }

    public boolean isOnBehalfOfInGroup(SwordContext swordContext, Group group) {
        EPerson onBehalfOf = swordContext.getOnBehalfOf();
        if (onBehalfOf != null) {
            return this.isInGroup(group, onBehalfOf);
        }
        return false;
    }

    public boolean isInGroup(Group group, EPerson eperson) {
        EPerson[] eps = group.getMembers();
        Group[] groups = group.getMemberGroups();
        for (int i = 0; i < eps.length; ++i) {
            if (eperson.getID() != eps[i].getID()) continue;
            return true;
        }
        if (groups != null && groups.length > 0) {
            for (int j = 0; j < groups.length; ++j) {
                if (!this.isInGroup(groups[j], eperson)) continue;
                return true;
            }
        }
        return false;
    }

    public List<Community> getAllowedCommunities(SwordContext swordContext) throws DSpaceSwordException {
        try {
            Context context = swordContext.getContext();
            ArrayList<Community> allowed = new ArrayList<Community>();
            Community[] comms = Community.findAllTop((Context)context);
            for (int i = 0; i < comms.length; ++i) {
                boolean authAllowed = false;
                boolean oboAllowed = false;
                if (swordContext.getOnBehalfOf() == null) {
                    oboAllowed = true;
                }
                if (!authAllowed) {
                    authAllowed = AuthorizeManager.authorizeActionBoolean((Context)swordContext.getAuthenticatorContext(), (DSpaceObject)comms[i], (int)0);
                }
                if (!oboAllowed) {
                    oboAllowed = AuthorizeManager.authorizeActionBoolean((Context)swordContext.getOnBehalfOfContext(), (DSpaceObject)comms[i], (int)0);
                }
                if (!authAllowed || !oboAllowed) continue;
                allowed.add(comms[i]);
            }
            return allowed;
        }
        catch (SQLException e) {
            log.error((Object)"Caught exception: ", (Throwable)e);
            throw new DSpaceSwordException((Throwable)e);
        }
    }

    public List<Community> getCommunities(SwordContext swordContext, Community community) throws DSpaceSwordException {
        try {
            Community[] comms = community.getSubcommunities();
            ArrayList<Community> allowed = new ArrayList<Community>();
            for (int i = 0; i < comms.length; ++i) {
                boolean authAllowed = false;
                boolean oboAllowed = false;
                if (swordContext.getOnBehalfOf() == null) {
                    oboAllowed = true;
                }
                if (!authAllowed) {
                    authAllowed = AuthorizeManager.authorizeActionBoolean((Context)swordContext.getAuthenticatorContext(), (DSpaceObject)comms[i], (int)0);
                }
                if (!oboAllowed) {
                    oboAllowed = AuthorizeManager.authorizeActionBoolean((Context)swordContext.getOnBehalfOfContext(), (DSpaceObject)comms[i], (int)0);
                }
                if (!authAllowed || !oboAllowed) continue;
                allowed.add(comms[i]);
            }
            return allowed;
        }
        catch (SQLException e) {
            log.error((Object)"Caught exception: ", (Throwable)e);
            throw new DSpaceSwordException((Throwable)e);
        }
    }

    public List<Collection> getAllowedCollections(SwordContext swordContext) throws DSpaceSwordException {
        return this.getAllowedCollections(swordContext, null);
    }

    public List<Collection> getAllowedCollections(SwordContext swordContext, Community community) throws DSpaceSwordException {
        try {
            Context authContext = swordContext.getAuthenticatorContext();
            Collection[] cols = Collection.findAuthorized((Context)authContext, (Community)community, (int)3);
            ArrayList<Collection> allowed = new ArrayList<Collection>();
            for (int i = 0; i < cols.length; ++i) {
                boolean oboAllowed = false;
                if (swordContext.getOnBehalfOf() == null) {
                    oboAllowed = true;
                }
                if (!oboAllowed) {
                    oboAllowed = AuthorizeManager.authorizeActionBoolean((Context)swordContext.getOnBehalfOfContext(), (DSpaceObject)cols[i], (int)3);
                }
                if (!oboAllowed) continue;
                allowed.add(cols[i]);
            }
            return allowed;
        }
        catch (SQLException e) {
            log.error((Object)"Caught exception: ", (Throwable)e);
            throw new DSpaceSwordException((Throwable)e);
        }
    }

    public List<Item> getAllowedItems(SwordContext swordContext, Collection collection) throws DSpaceSwordException {
        try {
            ArrayList<Item> allowed = new ArrayList<Item>();
            ItemIterator ii = collection.getItems();
            while (ii.hasNext()) {
                int i;
                boolean add;
                boolean write;
                Item item = ii.next();
                boolean authAllowed = false;
                boolean oboAllowed = false;
                if (swordContext.getOnBehalfOf() == null) {
                    oboAllowed = true;
                }
                Bundle[] bundles = item.getBundles("ORIGINAL");
                if (!authAllowed) {
                    write = AuthorizeManager.authorizeActionBoolean((Context)swordContext.getAuthenticatorContext(), (DSpaceObject)item, (int)1);
                    add = false;
                    if (bundles.length == 0) {
                        add = AuthorizeManager.authorizeActionBoolean((Context)swordContext.getAuthenticatorContext(), (DSpaceObject)item, (int)3);
                    } else {
                        for (i = 0; i < bundles.length && (add = AuthorizeManager.authorizeActionBoolean((Context)swordContext.getAuthenticatorContext(), (DSpaceObject)bundles[i], (int)3)); ++i) {
                        }
                    }
                    boolean bl = authAllowed = write && add;
                }
                if (!oboAllowed) {
                    write = AuthorizeManager.authorizeActionBoolean((Context)swordContext.getOnBehalfOfContext(), (DSpaceObject)item, (int)1);
                    add = false;
                    if (bundles.length == 0) {
                        add = AuthorizeManager.authorizeActionBoolean((Context)swordContext.getAuthenticatorContext(), (DSpaceObject)item, (int)3);
                    } else {
                        for (i = 0; i < bundles.length && (add = AuthorizeManager.authorizeActionBoolean((Context)swordContext.getAuthenticatorContext(), (DSpaceObject)bundles[i], (int)3)); ++i) {
                        }
                    }
                    boolean bl = oboAllowed = write && add;
                }
                if (!authAllowed || !oboAllowed) continue;
                allowed.add(item);
            }
            return allowed;
        }
        catch (SQLException e) {
            throw new DSpaceSwordException((Throwable)e);
        }
    }

    public boolean canSubmitTo(SwordContext swordContext, Collection collection) throws DSpaceSwordException {
        try {
            boolean authAllowed = false;
            boolean oboAllowed = false;
            if (swordContext.getOnBehalfOf() == null) {
                oboAllowed = true;
            }
            if (!authAllowed) {
                authAllowed = AuthorizeManager.authorizeActionBoolean((Context)swordContext.getAuthenticatorContext(), (DSpaceObject)collection, (int)3);
            }
            if (!oboAllowed) {
                oboAllowed = AuthorizeManager.authorizeActionBoolean((Context)swordContext.getOnBehalfOfContext(), (DSpaceObject)collection, (int)3);
            }
            return authAllowed && oboAllowed;
        }
        catch (SQLException e) {
            log.error((Object)"Caught exception: ", (Throwable)e);
            throw new DSpaceSwordException((Throwable)e);
        }
    }

    public boolean canSubmitTo(SwordContext swordContext, Item item) throws DSpaceSwordException {
        try {
            boolean isObo = swordContext.getOnBehalfOf() != null;
            Context allowContext = null;
            if (isObo) {
                if (!this.allowedToMediate(swordContext.getAuthenticatorContext())) {
                    return false;
                }
                allowContext = swordContext.getOnBehalfOfContext();
            } else {
                allowContext = swordContext.getAuthenticatorContext();
            }
            boolean write = AuthorizeManager.authorizeActionBoolean((Context)allowContext, (DSpaceObject)item, (int)1);
            Bundle[] bundles = item.getBundles("ORIGINAL");
            boolean add = false;
            if (bundles.length == 0) {
                add = AuthorizeManager.authorizeActionBoolean((Context)allowContext, (DSpaceObject)item, (int)3);
            } else {
                for (int i = 0; i < bundles.length && (add = AuthorizeManager.authorizeActionBoolean((Context)allowContext, (DSpaceObject)bundles[i], (int)3)); ++i) {
                }
            }
            boolean allowed = write && add;
            return allowed;
        }
        catch (SQLException e) {
            log.error((Object)"Caught exception: ", (Throwable)e);
            throw new DSpaceSwordException((Throwable)e);
        }
    }

    private boolean allowedToMediate(Context context) {
        String[] mediators;
        String mediatorCfg = ConfigurationManager.getProperty((String)"swordv2-server", (String)"on-behalf-of.update.mediators");
        if (mediatorCfg == null) {
            return true;
        }
        EPerson eperson = context.getCurrentUser();
        if (eperson == null) {
            return false;
        }
        String email = eperson.getEmail();
        String netid = eperson.getNetid();
        for (String mediator : mediators = mediatorCfg.split(",")) {
            String m = mediator.trim();
            if (email != null && m.equals(email.trim())) {
                return true;
            }
            if (netid == null || !m.equals(netid.trim())) continue;
            return true;
        }
        return false;
    }

    public boolean canSubmitTo(SwordContext context, DSpaceObject dso) throws DSpaceSwordException {
        if (dso instanceof Collection) {
            return this.canSubmitTo(context, (Collection)dso);
        }
        if (dso instanceof Item) {
            return this.canSubmitTo(context, (Item)dso);
        }
        return false;
    }
}

