/*
 * Decompiled with CFR 0.152.
 */
package org.swordapp.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.abdera.model.Entry;
import org.swordapp.server.SwordEntry;
import org.swordapp.server.SwordServerException;

public class Deposit {
    private SwordEntry entry = null;
    private InputStream inputStream = null;
    private String filename;
    private String mimeType;
    private String slug = null;
    private String md5 = null;
    private String packaging;
    private boolean inProgress = false;
    private boolean metadataRelevant = true;
    private File file = null;

    public Deposit() {
    }

    public Deposit(Entry entry, InputStream inputStream, String filename, String mimeType, String slug, String md5, String packaging, boolean inProgress) {
        this.entry = new SwordEntry(entry);
        this.inputStream = inputStream;
        this.filename = filename;
        this.mimeType = mimeType;
        this.slug = slug;
        this.md5 = md5;
        this.packaging = packaging;
        this.inProgress = inProgress;
    }

    public boolean isEntryOnly() {
        return this.entry != null && this.inputStream == null && this.file == null;
    }

    public boolean isMultipart() {
        return this.entry != null && (this.inputStream != null || this.file != null);
    }

    public boolean isBinaryOnly() {
        return this.entry == null && (this.inputStream != null || this.file != null);
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
        this.inputStream = null;
    }

    public SwordEntry getSwordEntry() {
        return this.entry;
    }

    public void setEntry(Entry entry) {
        this.entry = new SwordEntry(entry);
    }

    public InputStream getInputStream() throws SwordServerException {
        try {
            if (this.inputStream == null && this.file == null) {
                return null;
            }
            if (this.inputStream == null && this.file != null) {
                return new FileInputStream(this.file);
            }
            if (this.inputStream != null) {
                return this.inputStream;
            }
            return null;
        }
        catch (FileNotFoundException e) {
            throw new SwordServerException((Throwable)e);
        }
        catch (IOException e) {
            throw new SwordServerException((Throwable)e);
        }
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getSlug() {
        return this.slug;
    }

    public void setSlug(String slug) {
        this.slug = slug;
    }

    public String getMd5() {
        return this.md5;
    }

    public void setMd5(String md5) {
        this.md5 = md5;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public void setPackaging(String packaging) {
        this.packaging = packaging;
    }

    public boolean isInProgress() {
        return this.inProgress;
    }

    public void setInProgress(boolean inProgress) {
        this.inProgress = inProgress;
    }

    public boolean isMetadataRelevant() {
        return this.metadataRelevant;
    }

    public void setMetadataRelevant(boolean metadataRelevant) {
        this.metadataRelevant = metadataRelevant;
    }
}

