/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword2;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.dspace.content.DCValue;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.sword2.DSpaceSwordException;
import org.dspace.sword2.SwordEntryDisseminator;
import org.swordapp.server.DepositReceipt;
import org.swordapp.server.SwordError;
import org.swordapp.server.SwordServerException;

public class SimpleDCEntryDisseminator
implements SwordEntryDisseminator {
    private Map<String, String> dcMap = new HashMap();

    public SimpleDCEntryDisseminator() {
        Properties props = ConfigurationManager.getProperties();
        for (Object key : props.keySet()) {
            String keyString = (String)key;
            if (!keyString.startsWith("sword2.simpledc.")) continue;
            String k = keyString.substring("sword2.simpledc.".length());
            String v = (String)props.get(key);
            this.dcMap.put(k, v);
        }
    }

    public DepositReceipt disseminate(Context context, Item item, DepositReceipt receipt) throws DSpaceSwordException, SwordError, SwordServerException {
        DCValue[] all;
        for (DCValue dcv : all = item.getMetadata("*", "*", "*", "*")) {
            String valueMatch = dcv.schema + "." + dcv.element;
            if (dcv.qualifier != null) {
                valueMatch = valueMatch + "." + dcv.qualifier;
            }
            for (String key : this.dcMap.keySet()) {
                String value = (String)this.dcMap.get(key);
                if (!valueMatch.equals(value)) continue;
                receipt.addDublinCore(key, dcv.value);
                if (key.equals("title")) {
                    receipt.getWrappedEntry().setTitle(dcv.value);
                }
                if (!key.equals("abstract")) continue;
                receipt.getWrappedEntry().setSummary(dcv.value);
            }
        }
        return receipt;
    }
}

