/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword2;

import org.apache.abdera.i18n.iri.IRI;
import org.apache.log4j.Logger;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.handle.HandleManager;
import org.dspace.sword2.AtomCollectionGenerator;
import org.dspace.sword2.DSpaceSwordException;
import org.dspace.sword2.SwordConfigurationDSpace;
import org.dspace.sword2.SwordUrlManager;
import org.swordapp.server.SwordCollection;

public class CommunityCollectionGenerator
implements AtomCollectionGenerator {
    private static Logger log = Logger.getLogger(CommunityCollectionGenerator.class);

    public SwordCollection buildCollection(Context context, DSpaceObject dso, SwordConfigurationDSpace swordConfig) throws DSpaceSwordException {
        String dcAbstract;
        if (!(dso instanceof Community)) {
            log.error((Object)"buildCollection passed something other than a Community object");
            throw new DSpaceSwordException("Incorrect ATOMCollectionGenerator instantiated");
        }
        SwordUrlManager urlManager = swordConfig.getUrlManager(context, swordConfig);
        Community com = (Community)dso;
        SwordCollection scol = new SwordCollection();
        String location = urlManager.getDepositLocation(com);
        if (location == null) {
            location = HandleManager.getCanonicalForm((String)com.getHandle());
        }
        scol.setLocation(location);
        String title = com.getMetadata("name");
        if (title != null && !"".equals(title)) {
            scol.setTitle(title);
        }
        if ((dcAbstract = com.getMetadata("short_description")) != null && !"".equals(dcAbstract)) {
            scol.setAbstract(dcAbstract);
        }
        scol.setMediation(swordConfig.isMediated());
        String subService = urlManager.constructSubServiceUrl(com);
        scol.addSubService(new IRI(subService));
        log.debug((Object)"Created ATOM Collection for DSpace Community");
        return scol;
    }
}

