/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword2;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.core.Utils;
import org.dspace.sword2.DSpaceSwordException;
import org.dspace.sword2.DepositResult;
import org.dspace.sword2.SwordAuthenticator;
import org.dspace.sword2.SwordConfigurationDSpace;
import org.dspace.sword2.SwordContext;
import org.dspace.sword2.VerboseDescription;
import org.swordapp.server.AuthCredentials;
import org.swordapp.server.Deposit;
import org.swordapp.server.SwordAuthException;
import org.swordapp.server.SwordError;
import org.swordapp.server.SwordServerException;
import org.swordapp.server.UriRegistry;

public class DSpaceSwordAPI {
    private static Logger log = Logger.getLogger(DSpaceSwordAPI.class);

    public SwordContext noAuthContext() throws DSpaceSwordException {
        try {
            SwordContext sc = new SwordContext();
            Context context = new Context();
            sc.setContext(context);
            return sc;
        }
        catch (SQLException e) {
            throw new DSpaceSwordException((Throwable)e);
        }
    }

    public SwordContext doAuth(AuthCredentials authCredentials) throws SwordAuthException, SwordError, DSpaceSwordException {
        SwordAuthenticator auth = new SwordAuthenticator();
        SwordContext sc = auth.authenticate(authCredentials);
        String un = authCredentials.getUsername() != null ? authCredentials.getUsername() : "NONE";
        String obo = authCredentials.getOnBehalfOf() != null ? authCredentials.getOnBehalfOf() : "NONE";
        log.info((Object)LogManager.getHeader((Context)sc.getContext(), (String)"sword_auth_request", (String)("username=" + un + ",on_behalf_of=" + obo)));
        return sc;
    }

    public String getHeader(Map<String, String> map, String header, String def) {
        for (String key : map.keySet()) {
            if (!key.toLowerCase().equals(header.toLowerCase())) continue;
            return map.get(key);
        }
        return def;
    }

    public TreeMap<Float, List<String>> analyseAccept(String acceptHeader) {
        if (acceptHeader == null) {
            return null;
        }
        String[] parts = acceptHeader.split(",");
        ArrayList<Object[]> unsorted = new ArrayList<Object[]>();
        float highest_q = 0.0f;
        int counter = 0;
        for (String part : parts) {
            String[] components = part.split(";");
            String type = components[0].trim();
            String params = null;
            float q = -1 * ++counter;
            if (components.length == 2) {
                if (components[1].trim().startsWith("q=")) {
                    q = Float.parseFloat(components[1].trim().substring(2));
                    if (q > highest_q) {
                        highest_q = q;
                    }
                } else {
                    params = components[1].trim();
                }
            } else if (components.length == 3) {
                params = components[1].trim();
                q = Float.parseFloat(components[1].trim().substring(2));
                if (q > highest_q) {
                    highest_q = q;
                }
            }
            Object[] res = new Object[]{type, params, Float.valueOf(q)};
            unsorted.add(res);
        }
        float q_range = 1.0f - highest_q;
        TreeMap<Float, List<String>> sorted = new TreeMap<Float, List<String>>();
        for (Object[] oa : unsorted) {
            Float qv;
            String contentType = (String)oa[0];
            String p = (String)oa[1];
            if (p != null) {
                contentType = contentType + ";" + p;
            }
            if ((qv = (Float)oa[2]).floatValue() > 0.0f) {
                if (sorted.containsKey(qv)) {
                    sorted.get(qv).add(contentType);
                    continue;
                }
                ArrayList<String> cts = new ArrayList<String>();
                cts.add(contentType);
                sorted.put(qv, cts);
                continue;
            }
            float nq = 1.0f - q_range + -1.0f * qv.floatValue() / (float)counter * q_range;
            if (sorted.containsKey(Float.valueOf(nq))) {
                sorted.get(Float.valueOf(nq)).add(contentType);
                continue;
            }
            ArrayList<String> cts = new ArrayList<String>();
            cts.add(contentType);
            sorted.put(Float.valueOf(nq), cts);
        }
        return sorted;
    }

    public void isAcceptable(SwordConfigurationDSpace swordConfig, Context context, Deposit deposit, DSpaceObject dso) throws SwordError, DSpaceSwordException {
        if (!swordConfig.isAcceptableContentType(context, deposit.getMimeType(), dso)) {
            log.error((Object)("Unacceptable content type detected: " + deposit.getMimeType() + " for object " + dso.getID()));
            throw new SwordError(UriRegistry.ERROR_CONTENT, "Unacceptable content type in deposit request: " + deposit.getMimeType());
        }
        if (!swordConfig.isAcceptedPackaging(deposit.getPackaging(), dso)) {
            log.error((Object)("Unacceptable packaging type detected: " + deposit.getPackaging() + " for object " + dso.getID()));
            throw new SwordError(UriRegistry.ERROR_CONTENT, "Unacceptable packaging type in deposit request: " + deposit.getPackaging());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeOriginals(SwordConfigurationDSpace swordConfig, Context context, VerboseDescription verboseDescription, Deposit deposit, DepositResult result) throws DSpaceSwordException, SwordServerException {
        block21: {
            try {
                if (!swordConfig.isKeepOriginal()) break block21;
                verboseDescription.append("DSpace will store an original copy of the deposit, as well as ingesting the item into the archive");
                boolean ignoreAuth = context.ignoreAuthorization();
                context.setIgnoreAuthorization(true);
                String bundleName = ConfigurationManager.getProperty((String)"swordv2-server", (String)"bundle.name");
                if (bundleName == null || "".equals(bundleName)) {
                    bundleName = "SWORD";
                }
                Item item = result.getItem();
                Bundle[] bundles = item.getBundles(bundleName);
                Bundle swordBundle = null;
                if (bundles.length > 0) {
                    swordBundle = bundles[0];
                }
                if (swordBundle == null) {
                    swordBundle = item.createBundle(bundleName);
                }
                if (deposit.isMultipart() || deposit.isEntryOnly()) {
                    String entry = deposit.getSwordEntry().toString();
                    ByteArrayInputStream bais = new ByteArrayInputStream(entry.getBytes());
                    Bitstream entryBitstream = swordBundle.createBitstream((InputStream)bais);
                    String fn = this.createEntryFilename(context, deposit, true);
                    entryBitstream.setName(fn);
                    entryBitstream.setDescription("SWORD entry document");
                    BitstreamFormat bf = BitstreamFormat.findByMIMEType((Context)context, (String)"application/xml");
                    if (bf != null) {
                        entryBitstream.setFormat(bf);
                    }
                    entryBitstream.update();
                    verboseDescription.append("Original entry stored as " + fn + ", in item bundle " + swordBundle);
                }
                if (deposit.isMultipart() || deposit.isBinaryOnly()) {
                    Bitstream bitstream;
                    String fn = this.createFilename(context, deposit, true);
                    InputStream fis = null;
                    try {
                        fis = deposit.getInputStream();
                        bitstream = swordBundle.createBitstream(fis);
                    }
                    finally {
                        if (fis != null) {
                            try {
                                fis.close();
                            }
                            catch (IOException e) {}
                        }
                    }
                    bitstream.setName(fn);
                    bitstream.setDescription("SWORD deposit package");
                    BitstreamFormat bf = BitstreamFormat.findByMIMEType((Context)context, (String)deposit.getMimeType());
                    if (bf != null) {
                        bitstream.setFormat(bf);
                    }
                    bitstream.update();
                    if (result.getOriginalDeposit() == null) {
                        result.setOriginalDeposit(bitstream);
                    }
                    verboseDescription.append("Original package stored as " + fn + ", in item bundle " + swordBundle);
                }
                swordBundle.update();
                item.update();
                context.setIgnoreAuthorization(ignoreAuth);
            }
            catch (SQLException e) {
                log.error((Object)"caught exception: ", (Throwable)e);
                throw new DSpaceSwordException((Throwable)e);
            }
            catch (AuthorizeException e) {
                log.error((Object)"caught exception: ", (Throwable)e);
                throw new DSpaceSwordException((Throwable)e);
            }
            catch (FileNotFoundException e) {
                log.error((Object)"caught exception: ", (Throwable)e);
                throw new DSpaceSwordException((Throwable)e);
            }
            catch (IOException e) {
                log.error((Object)"caught exception: ", (Throwable)e);
                throw new DSpaceSwordException((Throwable)e);
            }
        }
    }

    public String createFilename(Context context, Deposit deposit, boolean original) throws DSpaceSwordException {
        try {
            String fn;
            BitstreamFormat bf = BitstreamFormat.findByMIMEType((Context)context, (String)deposit.getMimeType());
            String[] exts = null;
            if (bf != null) {
                exts = bf.getExtensions();
            }
            if ((fn = deposit.getFilename()) == null || "".equals(fn)) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                fn = "sword-" + sdf.format(new Date());
                if (original) {
                    fn = fn + ".original";
                }
                if (exts != null) {
                    fn = fn + "." + exts[0];
                }
            }
            return fn;
        }
        catch (SQLException e) {
            throw new DSpaceSwordException((Throwable)e);
        }
    }

    public String createEntryFilename(Context context, Deposit deposit, boolean original) throws DSpaceSwordException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        String fn = "sword-" + sdf.format(new Date());
        if (original) {
            fn = fn + ".original";
        }
        return fn + ".xml";
    }

    protected void storePackageAsFile(Deposit deposit, AuthCredentials auth, SwordConfigurationDSpace config) throws IOException {
        String path = config.getFailedPackageDir();
        File dir = new File(path);
        if (!dir.exists() || !dir.isDirectory()) {
            throw new IOException("Directory does not exist for writing packages on ingest error.");
        }
        String filenameBase = "sword-" + auth.getUsername() + "-" + new Date().getTime();
        File packageFile = new File(path, filenameBase);
        File headersFile = new File(path, filenameBase + "-headers");
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(deposit.getFile()));
        BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(packageFile));
        Utils.copy((InputStream)is, (OutputStream)fos);
        ((OutputStream)fos).close();
        ((InputStream)is).close();
        PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(headersFile)));
        pw.println("Filename=" + deposit.getFilename());
        pw.println("Content-Type=" + deposit.getMimeType());
        pw.println("Packaging=" + deposit.getPackaging());
        pw.println("On Behalf of=" + auth.getOnBehalfOf());
        pw.println("Slug=" + deposit.getSlug());
        pw.println("User name=" + auth.getUsername());
        pw.close();
    }

    protected void storeEntryAsFile(Deposit deposit, AuthCredentials auth, SwordConfigurationDSpace config) throws IOException {
        String path = config.getFailedPackageDir();
        File dir = new File(path);
        if (!dir.exists() || !dir.isDirectory()) {
            throw new IOException("Directory does not exist for writing packages on ingest error.");
        }
        String filenameBase = "sword-" + auth.getUsername() + "-" + new Date().getTime();
        File packageFile = new File(path, filenameBase);
        File headersFile = new File(path, filenameBase + "-headers");
        String entry = deposit.getSwordEntry().toString();
        ByteArrayInputStream is = new ByteArrayInputStream(entry.getBytes());
        BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(packageFile));
        Utils.copy((InputStream)is, (OutputStream)fos);
        ((OutputStream)fos).close();
        is.close();
        PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(headersFile)));
        pw.println("Filename=" + deposit.getFilename());
        pw.println("Content-Type=" + deposit.getMimeType());
        pw.println("Packaging=" + deposit.getPackaging());
        pw.println("On Behalf of=" + auth.getOnBehalfOf());
        pw.println("Slug=" + deposit.getSlug());
        pw.println("User name=" + auth.getUsername());
        pw.close();
    }
}

