/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.objectmanager;

import java.sql.SQLException;
import org.dspace.app.xmlui.objectmanager.AbstractAdapter;
import org.dspace.app.xmlui.wing.AttributeMap;
import org.dspace.app.xmlui.wing.Namespace;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.xml.sax.SAXException;

public class RepositoryAdapter
extends AbstractAdapter {
    public static String MODS_URI = "http://www.loc.gov/mods/v3";
    public static Namespace MODS = new Namespace(MODS_URI);
    private String dmdSecIDS;
    private Context context;

    public RepositoryAdapter(Context context, String contextPath) {
        super(contextPath);
        this.context = context;
    }

    protected String getMETSID() {
        return ConfigurationManager.getProperty((String)"handle.prefix");
    }

    protected String getMETSOBJID() throws WingException {
        if (this.contextPath == null) {
            return "/";
        }
        return this.contextPath + "/";
    }

    protected String getMETSOBJEDIT() {
        return null;
    }

    protected String getMETSProfile() {
        return "DRI DSPACE Repository Profile 1.0";
    }

    protected String getMETSLabel() {
        return "DSpace Repository";
    }

    protected void renderDescriptiveSection() throws SAXException {
        String dmdID = this.getGenericID("dmd_");
        String groupID = this.getGenericID("group_dmd_");
        AttributeMap attributes = new AttributeMap();
        attributes.put((Object)"ID", (Object)dmdID);
        attributes.put((Object)"GROUPID", (Object)groupID);
        this.startElement(METS, "dmdSec", attributes);
        attributes = new AttributeMap();
        attributes.put((Object)"MDTYPE", (Object)"OTHER");
        attributes.put((Object)"OTHERMDTYPE", (Object)"DIM");
        this.startElement(METS, "mdWrap", attributes);
        this.startElement(METS, "xmlData", new AttributeMap[0]);
        attributes = new AttributeMap();
        attributes.put((Object)"dspaceType", (Object)Constants.typeText[5]);
        this.startElement(DIM, "dim", attributes);
        attributes = new AttributeMap();
        attributes.put((Object)"mdschema", (Object)"dspace");
        attributes.put((Object)"element", (Object)"name");
        this.startElement(DIM, "field", attributes);
        this.sendCharacters(ConfigurationManager.getProperty((String)"dspace.name"));
        this.endElement(DIM, "field");
        attributes = new AttributeMap();
        attributes.put((Object)"mdschema", (Object)"dspace");
        attributes.put((Object)"element", (Object)"hostname");
        this.startElement(DIM, "field", attributes);
        this.sendCharacters(ConfigurationManager.getProperty((String)"dspace.hostname"));
        this.endElement(DIM, "field");
        attributes = new AttributeMap();
        attributes.put((Object)"mdschema", (Object)"dspace");
        attributes.put((Object)"element", (Object)"handle");
        this.startElement(DIM, "field", attributes);
        this.sendCharacters(ConfigurationManager.getProperty((String)"handle.prefix"));
        this.endElement(DIM, "field");
        attributes = new AttributeMap();
        attributes.put((Object)"mdschema", (Object)"dspace");
        attributes.put((Object)"element", (Object)"default");
        attributes.put((Object)"qualifier", (Object)"language");
        this.startElement(DIM, "field", attributes);
        this.sendCharacters(ConfigurationManager.getProperty((String)"default.language"));
        this.endElement(DIM, "field");
        this.endElement(DIM, "dim");
        this.endElement(METS, "xmlData");
        this.endElement(METS, "mdWrap");
        this.endElement(METS, "dmdSec");
        this.dmdSecIDS = dmdID;
    }

    protected void renderStructureMap() throws SQLException, SAXException {
        AttributeMap attributes = new AttributeMap();
        attributes.put((Object)"TYPE", (Object)"LOGICAL");
        attributes.put((Object)"LABEL", (Object)"DSpace");
        this.startElement(METS, "structMap", attributes);
        attributes = new AttributeMap();
        attributes.put((Object)"TYPE", (Object)"DSpace Repository");
        if (this.dmdSecIDS != null) {
            attributes.put((Object)"DMDID", (Object)this.dmdSecIDS);
        }
        this.startElement(METS, "div", attributes);
        for (Community community : Community.findAllTop((Context)this.context)) {
            this.renderStructuralDiv((DSpaceObject)community);
        }
        this.endElement(METS, "div");
        this.endElement(METS, "structMap");
    }

    private void renderStructuralDiv(DSpaceObject dso) throws SAXException, SQLException {
        AttributeMap attributes = new AttributeMap();
        if (dso instanceof Community) {
            attributes.put((Object)"TYPE", (Object)"DSpace Community");
        } else if (dso instanceof Collection) {
            attributes.put((Object)"TYPE", (Object)"DSpace Collection");
        }
        this.startElement(METS, "div", attributes);
        attributes = new AttributeMap();
        AttributeMap attributesXLINK = new AttributeMap();
        attributesXLINK.setNamespace(XLINK);
        attributes.put((Object)"LOCTYPE", (Object)"URL");
        attributesXLINK.put((Object)"href", (Object)("/metadata/handle/" + dso.getHandle() + "/mets.xml"));
        this.startElement(METS, "mptr", attributes, attributesXLINK);
        this.endElement(METS, "mptr");
        if (dso instanceof Community) {
            for (Collection collection : ((Community)dso).getCollections()) {
                this.renderStructuralDiv((DSpaceObject)collection);
            }
            for (Collection collection : ((Community)dso).getSubcommunities()) {
                this.renderStructuralDiv((DSpaceObject)collection);
            }
        }
        this.endElement(METS, "div");
    }
}

