/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.cocoon;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.configuration.MutableConfiguration;
import org.apache.cocoon.transformation.I18nTransformer;
import org.apache.log4j.Logger;
import org.dspace.app.xmlui.configuration.Aspect;
import org.dspace.app.xmlui.configuration.XMLUIConfiguration;

public class DSpaceI18NTransformer
extends I18nTransformer {
    private static Logger log = Logger.getLogger(DSpaceI18NTransformer.class);
    public static final String DEFAULT_BASE_LOCATION = "context://i18n/";

    public void configure(Configuration originalConf) throws ConfigurationException {
        DefaultConfiguration modifiedConf = new DefaultConfiguration(originalConf, true);
        MutableConfiguration cataloguesConf = modifiedConf.getMutableChild("catalogues", true);
        for (MutableConfiguration catalogueConf : cataloguesConf.getMutableChildren()) {
            if ("false".equals(catalogueConf.getAttribute("aspects", "false"))) continue;
            String baseCatalogueLocationPath = DEFAULT_BASE_LOCATION;
            Configuration baseCatalogueLocationConf = catalogueConf.getChild("location");
            if (baseCatalogueLocationConf != null) {
                baseCatalogueLocationPath = baseCatalogueLocationConf.getValue();
            }
            if (!baseCatalogueLocationPath.endsWith("/")) {
                baseCatalogueLocationPath = baseCatalogueLocationPath + "/";
            }
            String catalogueId = catalogueConf.getAttribute("id", "unknown");
            for (Aspect aspect : XMLUIConfiguration.getAspectChain()) {
                String baseLocationPath = aspect.getPath();
                int idx = baseLocationPath.indexOf("://");
                if (idx > 0) {
                    baseLocationPath = baseLocationPath.substring(idx + 3, baseLocationPath.length());
                }
                baseLocationPath = baseCatalogueLocationPath + baseLocationPath;
                DefaultConfiguration baseLocation = new DefaultConfiguration("location");
                baseLocation.setValue(baseLocationPath);
                catalogueConf.addChild((Configuration)baseLocation);
                String aspectLocationPath = aspect.getPath();
                if (!aspectLocationPath.endsWith("/")) {
                    aspectLocationPath = aspectLocationPath + "/";
                }
                aspectLocationPath = aspectLocationPath + "i18n/";
                DefaultConfiguration aspectLocation = new DefaultConfiguration("location");
                aspectLocation.setValue(aspectLocationPath);
                catalogueConf.addChild((Configuration)aspectLocation);
                log.info((Object)("Adding i18n location path for '" + catalogueId + "' catalogue: " + baseLocationPath));
                log.info((Object)("Adding i18n location path for '" + catalogueId + "' catalogue: " + aspectLocationPath));
            }
        }
        super.configure((Configuration)modifiedConf);
    }
}

