/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.submission;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Cell;
import org.dspace.app.xmlui.wing.element.CheckBox;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.app.xmlui.wing.element.Row;
import org.dspace.app.xmlui.wing.element.Table;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.DCValue;
import org.dspace.content.SupervisedItem;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.workflow.WorkflowItem;
import org.dspace.workflow.WorkflowManager;
import org.xml.sax.SAXException;

public class Submissions
extends AbstractDSpaceTransformer {
    protected static final Message T_title = Submissions.message((String)"xmlui.Submission.Submissions.title");
    protected static final Message T_dspace_home = Submissions.message((String)"xmlui.general.dspace_home");
    protected static final Message T_trail = Submissions.message((String)"xmlui.Submission.Submissions.trail");
    protected static final Message T_head = Submissions.message((String)"xmlui.Submission.Submissions.head");
    protected static final Message T_untitled = Submissions.message((String)"xmlui.Submission.Submissions.untitled");
    protected static final Message T_email = Submissions.message((String)"xmlui.Submission.Submissions.email");
    protected static final Message T_w_head1 = Submissions.message((String)"xmlui.Submission.Submissions.workflow_head1");
    protected static final Message T_w_info1 = Submissions.message((String)"xmlui.Submission.Submissions.workflow_info1");
    protected static final Message T_w_head2 = Submissions.message((String)"xmlui.Submission.Submissions.workflow_head2");
    protected static final Message T_w_column1 = Submissions.message((String)"xmlui.Submission.Submissions.workflow_column1");
    protected static final Message T_w_column2 = Submissions.message((String)"xmlui.Submission.Submissions.workflow_column2");
    protected static final Message T_w_column3 = Submissions.message((String)"xmlui.Submission.Submissions.workflow_column3");
    protected static final Message T_w_column4 = Submissions.message((String)"xmlui.Submission.Submissions.workflow_column4");
    protected static final Message T_w_column5 = Submissions.message((String)"xmlui.Submission.Submissions.workflow_column5");
    protected static final Message T_w_submit_return = Submissions.message((String)"xmlui.Submission.Submissions.workflow_submit_return");
    protected static final Message T_w_info2 = Submissions.message((String)"xmlui.Submission.Submissions.workflow_info2");
    protected static final Message T_w_head3 = Submissions.message((String)"xmlui.Submission.Submissions.workflow_head3");
    protected static final Message T_w_submit_take = Submissions.message((String)"xmlui.Submission.Submissions.workflow_submit_take");
    protected static final Message T_w_info3 = Submissions.message((String)"xmlui.Submission.Submissions.workflow_info3");
    protected static final Message T_s_head1 = Submissions.message((String)"xmlui.Submission.Submissions.submit_head1");
    protected static final Message T_s_info1a = Submissions.message((String)"xmlui.Submission.Submissions.submit_info1a");
    protected static final Message T_s_info1b = Submissions.message((String)"xmlui.Submission.Submissions.submit_info1b");
    protected static final Message T_s_info1c = Submissions.message((String)"xmlui.Submission.Submissions.submit_info1c");
    protected static final Message T_s_head2 = Submissions.message((String)"xmlui.Submission.Submissions.submit_head2");
    protected static final Message T_s_info2a = Submissions.message((String)"xmlui.Submission.Submissions.submit_info2a");
    protected static final Message T_s_info2b = Submissions.message((String)"xmlui.Submission.Submissions.submit_info2b");
    protected static final Message T_s_info2c = Submissions.message((String)"xmlui.Submission.Submissions.submit_info2c");
    protected static final Message T_s_column1 = Submissions.message((String)"xmlui.Submission.Submissions.submit_column1");
    protected static final Message T_s_column2 = Submissions.message((String)"xmlui.Submission.Submissions.submit_column2");
    protected static final Message T_s_column3 = Submissions.message((String)"xmlui.Submission.Submissions.submit_column3");
    protected static final Message T_s_column4 = Submissions.message((String)"xmlui.Submission.Submissions.submit_column4");
    protected static final Message T_s_head3 = Submissions.message((String)"xmlui.Submission.Submissions.submit_head3");
    protected static final Message T_s_info3 = Submissions.message((String)"xmlui.Submission.Submissions.submit_info3");
    protected static final Message T_s_head4 = Submissions.message((String)"xmlui.Submission.Submissions.submit_head4");
    protected static final Message T_s_submit_remove = Submissions.message((String)"xmlui.Submission.Submissions.submit_submit_remove");
    protected static final Message T_p_head1 = Submissions.message((String)"xmlui.Submission.Submissions.progress_head1");
    protected static final Message T_p_info1 = Submissions.message((String)"xmlui.Submission.Submissions.progress_info1");
    protected static final Message T_p_column1 = Submissions.message((String)"xmlui.Submission.Submissions.progress_column1");
    protected static final Message T_p_column2 = Submissions.message((String)"xmlui.Submission.Submissions.progress_column2");
    protected static final Message T_p_column3 = Submissions.message((String)"xmlui.Submission.Submissions.progress_column3");
    protected static final Message T_status_0 = Submissions.message((String)"xmlui.Submission.Submissions.status_0");
    protected static final Message T_status_1 = Submissions.message((String)"xmlui.Submission.Submissions.status_1");
    protected static final Message T_status_2 = Submissions.message((String)"xmlui.Submission.Submissions.status_2");
    protected static final Message T_status_3 = Submissions.message((String)"xmlui.Submission.Submissions.status_3");
    protected static final Message T_status_4 = Submissions.message((String)"xmlui.Submission.Submissions.status_4");
    protected static final Message T_status_5 = Submissions.message((String)"xmlui.Submission.Submissions.status_5");
    protected static final Message T_status_6 = Submissions.message((String)"xmlui.Submission.Submissions.status_6");
    protected static final Message T_status_7 = Submissions.message((String)"xmlui.Submission.Submissions.status_7");
    protected static final Message T_status_unknown = Submissions.message((String)"xmlui.Submission.Submissions.status_unknown");

    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrailLink(this.contextPath + "/submissions", T_trail);
    }

    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        Division div = body.addInteractiveDivision("submissions", this.contextPath + "/submissions", "post", "primary");
        div.setHead(T_head);
        this.addWorkflowTasks(div);
        this.addUnfinishedSubmissions(div);
        this.addSubmissionsInWorkflow(div);
    }

    private void addWorkflowTasks(Division division) throws SQLException, WingException {
        Row row;
        Cell cell;
        String displayTitle;
        CheckBox remove;
        Row row2;
        Message state;
        String submitterEmail;
        String submitterName;
        EPerson submitter;
        String collectionName;
        DCValue[] titles;
        String url;
        int workflowItemID;
        List ownedItems = WorkflowManager.getOwnedTasks((Context)this.context, (EPerson)this.context.getCurrentUser());
        List pooledItems = WorkflowManager.getPooledTasks((Context)this.context, (EPerson)this.context.getCurrentUser());
        if (ownedItems.size() <= 0 && pooledItems.size() <= 0) {
            return;
        }
        Division workflow = division.addDivision("workflow-tasks");
        workflow.setHead(T_w_head1);
        workflow.addPara(T_w_info1);
        Table table = workflow.addTable("workflow-tasks", ownedItems.size() + 2, 5);
        table.setHead(T_w_head2);
        Row header = table.addRow("header");
        header.addCellContent(T_w_column1);
        header.addCellContent(T_w_column2);
        header.addCellContent(T_w_column3);
        header.addCellContent(T_w_column4);
        header.addCellContent(T_w_column5);
        if (ownedItems.size() > 0) {
            for (WorkflowItem owned : ownedItems) {
                workflowItemID = owned.getID();
                url = this.contextPath + "/handle/" + owned.getCollection().getHandle() + "/workflow?workflowID=" + workflowItemID;
                titles = owned.getItem().getDC("title", null, "*");
                collectionName = owned.getCollection().getMetadata("name");
                submitter = owned.getSubmitter();
                submitterName = submitter.getFullName();
                submitterEmail = submitter.getEmail();
                state = this.getWorkflowStateMessage(owned);
                row2 = table.addRow();
                remove = row2.addCell().addCheckBox("workflowID");
                remove.setLabel("selected");
                remove.addOption(workflowItemID);
                row2.addCell().addXref(url, state);
                if (titles != null && titles.length > 0) {
                    displayTitle = titles[0].value;
                    if (displayTitle.length() > 50) {
                        displayTitle = displayTitle.substring(0, 50) + " ...";
                    }
                    row2.addCell().addXref(url, displayTitle);
                } else {
                    row2.addCell().addXref(url, T_untitled);
                }
                row2.addCell().addXref(url, collectionName);
                cell = row2.addCell();
                cell.addContent(T_email);
                cell.addXref("mailto:" + submitterEmail, submitterName);
            }
            row = table.addRow();
            row.addCell(0, 5).addButton("submit_return_tasks").setValue(T_w_submit_return);
        } else {
            row = table.addRow();
            row.addCell(0, 5).addHighlight("italic").addContent(T_w_info2);
        }
        table = workflow.addTable("workflow-tasks", pooledItems.size() + 2, 5);
        table.setHead(T_w_head3);
        header = table.addRow("header");
        header.addCellContent(T_w_column1);
        header.addCellContent(T_w_column2);
        header.addCellContent(T_w_column3);
        header.addCellContent(T_w_column4);
        header.addCellContent(T_w_column5);
        if (pooledItems.size() > 0) {
            for (WorkflowItem pooled : pooledItems) {
                workflowItemID = pooled.getID();
                url = this.contextPath + "/handle/" + pooled.getCollection().getHandle() + "/workflow?workflowID=" + workflowItemID;
                titles = pooled.getItem().getDC("title", null, "*");
                collectionName = pooled.getCollection().getMetadata("name");
                submitter = pooled.getSubmitter();
                submitterName = submitter.getFullName();
                submitterEmail = submitter.getEmail();
                state = this.getWorkflowStateMessage(pooled);
                row2 = table.addRow();
                remove = row2.addCell().addCheckBox("workflowID");
                remove.setLabel("selected");
                remove.addOption(workflowItemID);
                row2.addCell().addXref(url, state);
                if (titles != null && titles.length > 0) {
                    displayTitle = titles[0].value;
                    if (displayTitle.length() > 50) {
                        displayTitle = displayTitle.substring(0, 50) + " ...";
                    }
                    row2.addCell().addXref(url, displayTitle);
                } else {
                    row2.addCell().addXref(url, T_untitled);
                }
                row2.addCell().addXref(url, collectionName);
                cell = row2.addCell();
                cell.addContent(T_email);
                cell.addXref("mailto:" + submitterEmail, submitterName);
            }
            row = table.addRow();
            row.addCell(0, 5).addButton("submit_take_tasks").setValue(T_w_submit_take);
        } else {
            row = table.addRow();
            row.addCell(0, 5).addHighlight("italic").addContent(T_w_info3);
        }
    }

    private void addUnfinishedSubmissions(Division division) throws SQLException, WingException {
        Cell cell;
        String displayTitle;
        Row row;
        String collectionName;
        String submitterEmail;
        String submitterName;
        String url;
        int workspaceItemID;
        EPerson submitterEPerson;
        DCValue[] titles;
        Collection[] collections;
        WorkspaceItem[] unfinishedItems = WorkspaceItem.findByEPerson((Context)this.context, (EPerson)this.context.getCurrentUser());
        SupervisedItem[] supervisedItems = SupervisedItem.findbyEPerson((Context)this.context, (EPerson)this.context.getCurrentUser());
        if (unfinishedItems.length <= 0 && supervisedItems.length <= 0 && (collections = Collection.findAuthorized((Context)this.context, null, (int)3)).length > 0) {
            Division start = division.addDivision("start-submision");
            start.setHead(T_s_head1);
            Para p = start.addPara();
            p.addContent(T_s_info1a);
            p.addXref(this.contextPath + "/submit", T_s_info1b);
            p.addContent(T_s_info1c);
            return;
        }
        Division unfinished = division.addInteractiveDivision("unfinished-submisions", this.contextPath + "/submit", "post");
        unfinished.setHead(T_s_head2);
        Para p = unfinished.addPara();
        p.addContent(T_s_info2a);
        p.addHighlight("bold").addXref(this.contextPath + "/submit", T_s_info2b);
        p.addContent(T_s_info2c);
        int rows = unfinishedItems.length + supervisedItems.length + 2;
        if (supervisedItems.length > 0 && unfinishedItems.length > 0) {
            ++rows;
        }
        if (supervisedItems.length > 0) {
            ++rows;
        }
        Table table = unfinished.addTable("unfinished-submissions", rows, 5);
        Row header = table.addRow("header");
        header.addCellContent(T_s_column1);
        header.addCellContent(T_s_column2);
        header.addCellContent(T_s_column3);
        header.addCellContent(T_s_column4);
        if (supervisedItems.length > 0 && unfinishedItems.length > 0) {
            header = table.addRow();
            header.addCell(null, "header", 0, 5, null).addContent(T_s_head3);
        }
        if (unfinishedItems.length > 0) {
            for (WorkspaceItem workspaceItem : unfinishedItems) {
                titles = workspaceItem.getItem().getDC("title", null, "*");
                submitterEPerson = workspaceItem.getItem().getSubmitter();
                workspaceItemID = workspaceItem.getID();
                url = this.contextPath + "/submit?workspaceID=" + workspaceItemID;
                submitterName = submitterEPerson.getFullName();
                submitterEmail = submitterEPerson.getEmail();
                collectionName = workspaceItem.getCollection().getMetadata("name");
                row = table.addRow("data");
                CheckBox remove = row.addCell().addCheckBox("workspaceID");
                remove.setLabel("remove");
                remove.addOption(workspaceItemID);
                if (titles.length > 0) {
                    displayTitle = titles[0].value;
                    if (displayTitle.length() > 50) {
                        displayTitle = displayTitle.substring(0, 50) + " ...";
                    }
                    row.addCell().addXref(url, displayTitle);
                } else {
                    row.addCell().addXref(url, T_untitled);
                }
                row.addCell().addXref(url, collectionName);
                cell = row.addCell();
                cell.addContent(T_email);
                cell.addXref("mailto:" + submitterEmail, submitterName);
            }
        } else {
            header = table.addRow();
            header.addCell(0, 5).addHighlight("italic").addContent(T_s_info3);
        }
        if (supervisedItems.length > 0) {
            header = table.addRow();
            header.addCell(null, "header", 0, 5, null).addContent(T_s_head4);
        }
        for (WorkspaceItem workspaceItem : supervisedItems) {
            titles = workspaceItem.getItem().getDC("title", null, "*");
            submitterEPerson = workspaceItem.getItem().getSubmitter();
            workspaceItemID = workspaceItem.getID();
            url = this.contextPath + "/submit?workspaceID=" + workspaceItemID;
            submitterName = submitterEPerson.getFullName();
            submitterEmail = submitterEPerson.getEmail();
            collectionName = workspaceItem.getCollection().getMetadata("name");
            row = table.addRow("data");
            CheckBox selected = row.addCell().addCheckBox("workspaceID");
            selected.setLabel("select");
            selected.addOption(workspaceItemID);
            if (titles.length > 0) {
                displayTitle = titles[0].value;
                if (displayTitle.length() > 50) {
                    displayTitle = displayTitle.substring(0, 50) + " ...";
                }
                row.addCell().addXref(url, displayTitle);
            } else {
                row.addCell().addXref(url, T_untitled);
            }
            row.addCell().addXref(url, collectionName);
            cell = row.addCell();
            cell.addContent(T_email);
            cell.addXref("mailto:" + submitterEmail, submitterName);
        }
        header = table.addRow();
        Cell lastCell = header.addCell(0, 5);
        if (unfinishedItems.length > 0 || supervisedItems.length > 0) {
            lastCell.addButton("submit_submissions_remove").setValue(T_s_submit_remove);
        }
    }

    private void addSubmissionsInWorkflow(Division division) throws SQLException, WingException {
        WorkflowItem[] inprogressItems = WorkflowItem.findByEPerson((Context)this.context, (EPerson)this.context.getCurrentUser());
        if (inprogressItems.length <= 0) {
            return;
        }
        Division inprogress = division.addDivision("submissions-inprogress");
        inprogress.setHead(T_p_head1);
        inprogress.addPara(T_p_info1);
        Table table = inprogress.addTable("submissions-inprogress", inprogressItems.length + 1, 3);
        Row header = table.addRow("header");
        header.addCellContent(T_p_column1);
        header.addCellContent(T_p_column2);
        header.addCellContent(T_p_column3);
        for (WorkflowItem workflowItem : inprogressItems) {
            DCValue[] titles = workflowItem.getItem().getDC("title", null, "*");
            String collectionName = workflowItem.getCollection().getMetadata("name");
            Message state = this.getWorkflowStateMessage(workflowItem);
            Row row = table.addRow();
            if (titles.length > 0) {
                String displayTitle = titles[0].value;
                if (displayTitle.length() > 50) {
                    displayTitle = displayTitle.substring(0, 50) + " ...";
                }
                row.addCellContent(displayTitle);
            } else {
                row.addCellContent(T_untitled);
            }
            row.addCellContent(collectionName);
            row.addCellContent(state);
        }
    }

    private Message getWorkflowStateMessage(WorkflowItem workflowItem) {
        switch (workflowItem.getState()) {
            case 0: {
                return T_status_0;
            }
            case 1: {
                return T_status_1;
            }
            case 2: {
                return T_status_2;
            }
            case 3: {
                return T_status_3;
            }
            case 4: {
                return T_status_4;
            }
            case 5: {
                return T_status_5;
            }
            case 6: {
                return T_status_6;
            }
            case 7: {
                return T_status_7;
            }
        }
        return T_status_unknown;
    }
}

