/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.services.model;

import java.io.Serializable;
import java.util.Map;

public class Event
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    private String name;
    private String userId;
    private String resourceReference;
    private Scope[] scopes;
    private boolean modify;
    private Map<String, String> properties;

    public Event(String name) {
        this(name, null, null, null, null, false);
    }

    public Event(String name, String resourceReference, boolean modify) {
        this(name, resourceReference, null, null, null, modify);
    }

    public Event(String name, String resourceReference, boolean modify, boolean localOnly) {
        Scope[] scopeArray;
        if (localOnly) {
            Scope[] scopeArray2 = new Scope[1];
            scopeArray = scopeArray2;
            scopeArray2[0] = Scope.LOCAL;
        } else {
            scopeArray = null;
        }
        this(name, resourceReference, null, null, scopeArray, modify);
    }

    public Event(String name, String resourceReference, String userId, boolean modify) {
        this(name, resourceReference, userId, null, null, modify);
    }

    public Event(String name, String resourceReference, String userId, Map<String, String> properties, Scope[] scopes, boolean modify) {
        this.modify = false;
        this.name = name;
        this.userId = userId;
        this.modify = modify;
        this.resourceReference = resourceReference;
        this.properties = properties;
        this.scopes = scopes == null || scopes.length == 0 ? new Scope[]{Scope.LOCAL, Scope.CLUSTER} : (Scope[])scopes.clone();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getResourceReference() {
        return this.resourceReference;
    }

    public void setResourceReference(String resourceReference) {
        this.resourceReference = resourceReference;
    }

    public boolean isModify() {
        return this.modify;
    }

    public void setModify(boolean modify) {
        this.modify = modify;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public Scope[] getScopes() {
        return this.scopes == null ? null : (Scope[])this.scopes.clone();
    }

    public void setScopes(Scope[] scopes) {
        this.scopes = scopes == null ? null : (Scope[])scopes.clone();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.scopes.length; ++i) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append((Object)this.scopes[i]);
        }
        return this.id + ":name=" + this.name + ":user=" + this.userId + ":resRef=" + this.resourceReference + ":mod=" + this.modify + ":scopes=" + sb;
    }

    public static enum Scope {
        LOCAL,
        CLUSTER,
        EXTERNAL;

    }
}

