/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.services.email;

import jakarta.annotation.PostConstruct;
import jakarta.mail.Authenticator;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.services.ConfigurationService;
import org.dspace.services.EmailService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class EmailServiceImpl
extends Authenticator
implements EmailService {
    private static final Logger logger = LogManager.getLogger();
    private Session session = null;
    private ConfigurationService cfg = null;

    @Autowired(required=true)
    public void setCfg(ConfigurationService cfg) {
        this.cfg = cfg;
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @PostConstruct
    public void init() {
        String sessionName = this.cfg.getProperty("mail.session.name");
        if (null == sessionName) {
            sessionName = "Session";
        }
        String sessionUri = "java:comp/env/mail/" + sessionName;
        logger.debug("Looking up Session as {}", (Object)sessionUri);
        try {
            InitialContext ctx = new InitialContext(null);
            this.session = (Session)ctx.lookup(sessionUri);
        }
        catch (NameNotFoundException | NoInitialContextException ctx) {
        }
        catch (NamingException ex) {
            logger.warn("Couldn't get an email session from environment:  {}:  {}", (Object)ex.getClass().getName(), (Object)ex.getMessage());
        }
        if (null != this.session) {
            logger.info("Email session retrieved from environment.");
        } else {
            String[] extras;
            String port;
            logger.info("Initializing an email session from configuration.");
            Properties props = new Properties();
            props.put("mail.transport.protocol", "smtp");
            String host = this.cfg.getProperty("mail.server");
            if (null != host) {
                props.put("mail.host", this.cfg.getProperty("mail.server"));
            }
            if (null != (port = this.cfg.getProperty("mail.server.port"))) {
                props.put("mail.smtp.port", port);
            }
            if ((extras = this.cfg.getArrayProperty("mail.extraproperties")) != null) {
                for (String argument : extras) {
                    String key = argument.substring(0, argument.indexOf(61)).trim();
                    String value = argument.substring(argument.indexOf(61) + 1).trim();
                    props.put(key, value);
                }
            }
            if (StringUtils.isBlank((CharSequence)this.cfg.getProperty("mail.server.username"))) {
                this.session = Session.getInstance((Properties)props);
            } else {
                props.put("mail.smtp.auth", "true");
                this.session = Session.getInstance((Properties)props, (Authenticator)this);
            }
        }
    }

    protected PasswordAuthentication getPasswordAuthentication() {
        if (null == this.cfg) {
            this.cfg = DSpaceServicesFactory.getInstance().getConfigurationService();
        }
        return new PasswordAuthentication(this.cfg.getProperty("mail.server.username"), this.cfg.getProperty("mail.server.password"));
    }

    public void reset() {
        this.session = null;
        this.init();
    }
}

