/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.servicemanager;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.kernel.DSpaceKernel;
import org.dspace.kernel.DSpaceKernelManager;
import org.dspace.servicemanager.DSpaceKernelImpl;

public class DSpaceKernelInit {
    private static final Logger log = LogManager.getLogger(DSpaceKernelInit.class);
    private static final Object staticLock = new Object();

    private DSpaceKernelInit() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DSpaceKernelImpl getKernel(String name) {
        if (name != null) {
            try {
                DSpaceKernel kernel = new DSpaceKernelManager().getKernel(name);
                if (kernel != null) {
                    if (kernel instanceof DSpaceKernelImpl) {
                        return (DSpaceKernelImpl)kernel;
                    }
                    throw new IllegalStateException("Wrong DSpaceKernel implementation");
                }
            }
            catch (Exception exception) {}
        } else if (DSpaceKernelManager.getDefaultKernel() != null) {
            return (DSpaceKernelImpl)DSpaceKernelManager.getDefaultKernel();
        }
        Object object = staticLock;
        synchronized (object) {
            DSpaceKernelImpl kernelImpl = new DSpaceKernelImpl(name);
            log.info("Created new kernel: {}", (Object)kernelImpl);
            if (name != null) {
                DSpaceKernelManager.registerMBean(kernelImpl.getMBeanName(), kernelImpl);
            } else {
                DSpaceKernelManager.setDefaultKernel(kernelImpl);
            }
            return kernelImpl;
        }
    }
}

