/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.VocabularyEntryRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.AbstractDSpaceRestRepository;
import org.dspace.app.rest.repository.LinkRestRepository;
import org.dspace.app.rest.utils.AuthorityUtils;
import org.dspace.content.authority.Choice;
import org.dspace.content.authority.ChoiceAuthority;
import org.dspace.content.authority.Choices;
import org.dspace.content.authority.service.ChoiceAuthorityService;
import org.dspace.content.service.CollectionService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="submission.vocabularies.entries")
public class VocabularyEntryLinkRepository
extends AbstractDSpaceRestRepository
implements LinkRestRepository {
    @Autowired
    private ChoiceAuthorityService cas;
    @Autowired
    private CollectionService cs;
    @Autowired
    private AuthorityUtils authorityUtils;

    @PreAuthorize(value="permitAll()")
    public Page<VocabularyEntryRest> filter(@Nullable HttpServletRequest request, String name, @Nullable Pageable optionalPageable, Projection projection) {
        Choice choice;
        String entryID;
        Context context = this.obtainContext();
        String exact = request == null ? null : request.getParameter("exact");
        String filter = request == null ? null : request.getParameter("filter");
        String string = entryID = request == null ? null : request.getParameter("entryID");
        if (StringUtils.isNotBlank((CharSequence)filter) && StringUtils.isNotBlank((CharSequence)entryID)) {
            throw new IllegalArgumentException("the filter and entryID parameters are mutually exclusive");
        }
        Pageable pageable = this.utils.getPageable(optionalPageable);
        ArrayList<VocabularyEntryRest> results = new ArrayList<VocabularyEntryRest>();
        ChoiceAuthority ca = this.cas.getChoiceAuthorityByAuthorityName(name);
        if (ca == null) {
            throw new ResourceNotFoundException("the vocabulary named " + name + "doesn't exist");
        }
        if (!ca.isScrollable() && StringUtils.isBlank((CharSequence)filter) && StringUtils.isBlank((CharSequence)entryID)) {
            throw new UnprocessableEntityException("one of filter or entryID parameter is required for not scrollable vocabularies");
        }
        Choices choices = null;
        choices = BooleanUtils.toBoolean((String)exact) ? ca.getBestMatch(filter, context.getCurrentLocale().toString()) : (StringUtils.isNotBlank((CharSequence)entryID) ? ((choice = ca.getChoice(entryID, context.getCurrentLocale().toString())) != null ? new Choices(new Choice[]{choice}, 0, 1, 600, false) : new Choices(false)) : ca.getMatches(filter, Math.toIntExact(pageable.getOffset()), pageable.getPageSize(), context.getCurrentLocale().toString()));
        boolean storeAuthority = ca.storeAuthorityInMetadata();
        for (Choice value : choices.values) {
            results.add(this.authorityUtils.convertEntry(value, name, storeAuthority, projection));
        }
        return new PageImpl(results, pageable, (long)choices.total);
    }
}

