/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;
import java.sql.SQLException;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.model.ItemRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.AbstractDSpaceRestRepository;
import org.dspace.app.rest.repository.LinkRestRepository;
import org.dspace.content.Item;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="integration.suggestiontargets.target")
public class SuggestionTargetTargetLinkRepository
extends AbstractDSpaceRestRepository
implements LinkRestRepository {
    @Autowired
    private ItemService itemService;

    @PreAuthorize(value="hasPermission(#id, 'SUGGESTIONTARGET', 'READ')")
    public ItemRest getTarget(@Nullable HttpServletRequest request, String id, @Nullable Pageable pageable, Projection projection) {
        String source = id.split(":")[0];
        UUID uuid = UUID.fromString(id.split(":")[1]);
        if (StringUtils.isBlank((CharSequence)source) || uuid == null) {
            throw new ResourceNotFoundException("No such item related to a suggestion target with UUID: " + id);
        }
        try {
            Context context = this.obtainContext();
            Item profile = (Item)this.itemService.find(context, uuid);
            if (profile == null) {
                throw new ResourceNotFoundException("No such item related to a suggestion target with UUID: " + id);
            }
            return (ItemRest)this.converter.toRest(profile, projection);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

