/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.util.List;
import java.util.UUID;
import org.dspace.app.rest.Parameter;
import org.dspace.app.rest.SearchRestMethod;
import org.dspace.app.rest.model.QASourceRest;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.core.Context;
import org.dspace.qaevent.QASource;
import org.dspace.qaevent.service.QAEventService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="integration.qualityassurancesources")
public class QASourceRestRepository
extends DSpaceRestRepository<QASourceRest, String> {
    @Autowired
    private QAEventService qaEventService;

    @Override
    @PreAuthorize(value="hasPermission(#id, 'QUALITYASSURANCESOURCE', 'READ')")
    public QASourceRest findOne(Context context, String id) {
        QASource qaSource = this.qaEventService.findSource(context, id);
        if (qaSource == null) {
            return null;
        }
        return (QASourceRest)this.converter.toRest(qaSource, this.utils.obtainProjection());
    }

    @Override
    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    public Page<QASourceRest> findAll(Context context, Pageable pageable) {
        List qaSources = this.qaEventService.findAllSources(context, pageable.getOffset(), pageable.getPageSize());
        long count = this.qaEventService.countSources(context);
        return this.converter.toRestPage(qaSources, pageable, count, this.utils.obtainProjection());
    }

    @SearchRestMethod(name="byTarget")
    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    public Page<QASourceRest> findByTarget(@Parameter(value="target", required=true) UUID target, Pageable pageable) {
        Context context = this.obtainContext();
        List topics = this.qaEventService.findAllSourcesByTarget(context, target, pageable.getOffset(), pageable.getPageSize());
        long count = this.qaEventService.countSourcesByTarget(context, target);
        if (topics == null) {
            return null;
        }
        return this.converter.toRestPage(topics, pageable, count, this.utils.obtainProjection());
    }

    @Override
    public Class<QASourceRest> getDomainClass() {
        return QASourceRest.class;
    }
}

