/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import com.fasterxml.jackson.databind.JsonNode;
import jakarta.servlet.http.HttpServletRequest;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.exception.RESTAuthorizationException;
import org.dspace.app.rest.exception.RepositoryMethodNotImplementedException;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.RestAddressableModel;
import org.dspace.app.rest.model.patch.Patch;
import org.dspace.app.rest.repository.AbstractDSpaceRestRepository;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.web.multipart.MultipartFile;

public abstract class DSpaceRestRepository<T extends RestAddressableModel, ID extends Serializable>
extends AbstractDSpaceRestRepository
implements CrudRepository<T, ID>,
PagingAndSortingRepository<T, ID>,
BeanNameAware {
    private String thisRepositoryBeanName;
    private DSpaceRestRepository<T, ID> thisRepository;
    @Autowired
    private ApplicationContext applicationContext;

    public void setBeanName(String beanName) {
        this.thisRepositoryBeanName = beanName;
    }

    private DSpaceRestRepository<T, ID> getThisRepository() {
        if (this.thisRepository == null) {
            this.thisRepository = (DSpaceRestRepository)this.applicationContext.getBean(this.thisRepositoryBeanName);
        }
        return this.thisRepository;
    }

    public <S extends T> S save(S entity) {
        Context context = null;
        try {
            context = this.obtainContext();
            S res = this.save(context, entity);
            context.commit();
            return res;
        }
        catch (AuthorizeException ex) {
            throw new RESTAuthorizationException(ex);
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    protected <S extends T> S save(Context context, S entity) throws AuthorizeException, RepositoryMethodNotImplementedException {
        throw new RepositoryMethodNotImplementedException("No implementation found; Method not allowed!", "");
    }

    public <S extends T> Iterable<S> saveAll(Iterable<S> entities) {
        return null;
    }

    public Optional<T> findById(ID id) {
        Context context = this.obtainContext();
        T object = this.getThisRepository().findOne(context, id);
        if (object == null) {
            return Optional.empty();
        }
        return Optional.of(object);
    }

    public abstract T findOne(Context var1, ID var2);

    public boolean existsById(ID id) {
        return this.findById(id).isPresent();
    }

    public final Iterable<T> findAll() {
        throw new RuntimeException("findAll MUST be paginated");
    }

    public Iterable<T> findAllById(Iterable<ID> ids) {
        throw new RuntimeException("findAll MUST be paginated");
    }

    public long count() {
        return 0L;
    }

    public synchronized void deleteById(ID id) {
        Context context = this.obtainContext();
        try {
            this.getThisRepository().delete(context, id);
            context.commit();
        }
        catch (AuthorizeException e) {
            throw new RESTAuthorizationException(e);
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    protected void delete(Context context, ID id) throws AuthorizeException, RepositoryMethodNotImplementedException {
        throw new RepositoryMethodNotImplementedException("No implementation found; Method not allowed!", "");
    }

    public void delete(T entity) {
    }

    public void deleteAll(Iterable<? extends T> entities) {
    }

    public void deleteAllById(Iterable<? extends ID> ids) {
    }

    public void deleteAll() {
    }

    public final Iterable<T> findAll(Sort sort) {
        throw new RuntimeException("findAll MUST be paginated");
    }

    public Page<T> findAll(Pageable pageable) {
        Context context = this.obtainContext();
        return this.getThisRepository().findAll(context, pageable);
    }

    public abstract Page<T> findAll(Context var1, Pageable var2);

    public abstract Class<T> getDomainClass();

    public T createAndReturn() {
        Context context = null;
        try {
            context = this.obtainContext();
            T entity = this.getThisRepository().createAndReturn(context);
            context.commit();
            return entity;
        }
        catch (AuthorizeException e) {
            throw new RESTAuthorizationException(e);
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public T createAndReturn(UUID uuid) {
        Context context = null;
        try {
            context = this.obtainContext();
            T entity = this.getThisRepository().createAndReturn(context, uuid);
            context.commit();
            return entity;
        }
        catch (AuthorizeException e) {
            throw new RESTAuthorizationException(e);
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public T createAndReturn(List<String> list) {
        Context context = null;
        try {
            context = this.obtainContext();
            T entity = this.getThisRepository().createAndReturn(context, list);
            context.commit();
            return entity;
        }
        catch (AuthorizeException e) {
            throw new RESTAuthorizationException(e);
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    protected T createAndReturn(Context context, UUID uuid) throws AuthorizeException, SQLException, RepositoryMethodNotImplementedException {
        throw new RepositoryMethodNotImplementedException("No implementation found; Method not allowed!", "");
    }

    protected T createAndReturn(Context context, List<String> list) throws AuthorizeException, SQLException, RepositoryMethodNotImplementedException {
        throw new RepositoryMethodNotImplementedException("No implementation found; Method not allowed!", "");
    }

    protected T createAndReturn(Context context) throws AuthorizeException, SQLException, RepositoryMethodNotImplementedException {
        throw new RepositoryMethodNotImplementedException("No implementation found; Method not allowed!", "");
    }

    public T upload(HttpServletRequest request, String apiCategory, String model, ID id, MultipartFile file) throws SQLException, FileNotFoundException, IOException, AuthorizeException {
        throw new RuntimeException("No implementation found; Method not allowed!");
    }

    public T patch(HttpServletRequest request, String apiCategory, String model, ID id, Patch patch) throws UnprocessableEntityException, DSpaceBadRequestException {
        Context context = this.obtainContext();
        try {
            this.getThisRepository().patch(context, request, apiCategory, model, id, patch);
            context.commit();
        }
        catch (AuthorizeException ae) {
            throw new RESTAuthorizationException(ae);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return (T)((RestAddressableModel)this.findById(id).orElse(null));
    }

    protected void patch(Context context, HttpServletRequest request, String apiCategory, String model, ID id, Patch patch) throws RepositoryMethodNotImplementedException, SQLException, AuthorizeException {
        throw new RepositoryMethodNotImplementedException(apiCategory, model);
    }

    public T action(HttpServletRequest request, ID id) throws SQLException, IOException {
        Context context = this.obtainContext();
        T entity = this.action(context, request, id);
        context.commit();
        return entity;
    }

    protected T action(Context context, HttpServletRequest request, ID id) throws SQLException, IOException {
        throw new RuntimeException("No implementation found; Method not allowed!");
    }

    public Iterable<T> upload(HttpServletRequest request, List<MultipartFile> uploadfile) throws SQLException, FileNotFoundException, IOException, AuthorizeException {
        Context context = this.obtainContext();
        Iterable<T> entity = this.upload(context, request, uploadfile);
        context.commit();
        return entity;
    }

    protected Iterable<T> upload(Context context, HttpServletRequest request, List<MultipartFile> uploadfile) throws SQLException, FileNotFoundException, IOException, AuthorizeException {
        throw new RepositoryMethodNotImplementedException("No implementation found; Method not allowed!", "");
    }

    public T put(HttpServletRequest request, String apiCategory, String model, ID uuid, JsonNode jsonNode) {
        Context context = this.obtainContext();
        try {
            this.getThisRepository().put(context, request, apiCategory, model, uuid, jsonNode);
            context.commit();
        }
        catch (SQLException e) {
            throw new RuntimeException("Unable to update DSpace object " + model + " with id=" + uuid, e);
        }
        catch (AuthorizeException e) {
            throw new RuntimeException("Unable to perform PUT request as the current user does not have sufficient rights", e);
        }
        return (T)((RestAddressableModel)this.findById(uuid).orElse(null));
    }

    public T put(HttpServletRequest request, String apiCategory, String model, ID id, List<String> stringList) {
        Context context = this.obtainContext();
        try {
            this.getThisRepository().put(context, request, apiCategory, model, id, stringList);
            context.commit();
        }
        catch (SQLException | AuthorizeException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return (T)((RestAddressableModel)this.findById(id).orElse(null));
    }

    protected T put(Context context, HttpServletRequest request, String apiCategory, String model, ID id, JsonNode jsonNode) throws RepositoryMethodNotImplementedException, SQLException, AuthorizeException {
        throw new RepositoryMethodNotImplementedException(apiCategory, model);
    }

    protected T put(Context context, HttpServletRequest request, String apiCategory, String model, ID id, List<String> stringList) throws RepositoryMethodNotImplementedException, SQLException, AuthorizeException {
        throw new RepositoryMethodNotImplementedException(apiCategory, model);
    }
}

