/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.signposting.service.impl;

import jakarta.servlet.http.HttpServletRequest;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.security.BitstreamMetadataReadPermissionEvaluatorPlugin;
import org.dspace.app.rest.signposting.model.LinksetNode;
import org.dspace.app.rest.signposting.processor.bitstream.BitstreamSignpostingProcessor;
import org.dspace.app.rest.signposting.processor.item.ItemLinksetProcessor;
import org.dspace.app.rest.signposting.processor.item.ItemSignpostingProcessor;
import org.dspace.app.rest.signposting.processor.metadata.MetadataSignpostingProcessor;
import org.dspace.app.rest.signposting.service.LinksetService;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.dspace.utils.DSpace;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LinksetServiceImpl
implements LinksetService {
    private static final Logger log = LogManager.getLogger(LinksetServiceImpl.class);
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    protected ItemService itemService;
    @Autowired
    private BitstreamMetadataReadPermissionEvaluatorPlugin bitstreamMetadataReadPermissionEvaluatorPlugin;
    @Autowired
    ItemLinksetProcessor itemLinksetProcessor;
    private final List<BitstreamSignpostingProcessor> bitstreamProcessors = new DSpace().getServiceManager().getServicesByType(BitstreamSignpostingProcessor.class);
    private final List<ItemSignpostingProcessor> itemProcessors = new DSpace().getServiceManager().getServicesByType(ItemSignpostingProcessor.class);
    private final List<MetadataSignpostingProcessor> metadataProcessors = new DSpace().getServiceManager().getServicesByType(MetadataSignpostingProcessor.class);

    @Override
    public List<List<LinksetNode>> createLinksetNodesForMultipleLinksets(HttpServletRequest request, Context context, Item item) {
        ArrayList<List<LinksetNode>> linksets = new ArrayList<List<LinksetNode>>();
        this.addItemLinksets(request, context, item, linksets);
        this.addBitstreamLinksets(request, context, item, linksets);
        this.addMetadataLinksets(request, context, item, linksets);
        return linksets;
    }

    @Override
    public List<LinksetNode> createLinksetNodesForSingleLinkset(HttpServletRequest request, Context context, DSpaceObject object) {
        ArrayList<LinksetNode> linksetNodes;
        block5: {
            block4: {
                int itemBitstreamsLimit = this.configurationService.getIntProperty("signposting.item.bitstreams.limit", 10);
                linksetNodes = new ArrayList<LinksetNode>();
                if (object.getType() != 2) break block4;
                int itemBitstreamsCount = this.countItemBitstreams((Item)object);
                if (itemBitstreamsCount < itemBitstreamsLimit) {
                    for (ItemSignpostingProcessor processor : this.itemProcessors) {
                        processor.addLinkSetNodes(context, request, (Item)object, linksetNodes);
                    }
                } else {
                    this.itemLinksetProcessor.addLinkSetNodes(context, request, (Item)object, (List<LinksetNode>)linksetNodes);
                }
                break block5;
            }
            if (object.getType() != 0) break block5;
            for (BitstreamSignpostingProcessor processor : this.bitstreamProcessors) {
                processor.addLinkSetNodes(context, request, (Bitstream)object, linksetNodes);
            }
        }
        return linksetNodes;
    }

    private void addItemLinksets(HttpServletRequest request, Context context, Item item, List<List<LinksetNode>> linksets) {
        ArrayList<LinksetNode> linksetNodes = new ArrayList<LinksetNode>();
        if (item.getType() == 2) {
            for (ItemSignpostingProcessor sp : this.itemProcessors) {
                sp.addLinkSetNodes(context, request, item, linksetNodes);
            }
        }
        linksets.add(linksetNodes);
    }

    private void addBitstreamLinksets(HttpServletRequest request, Context context, Item item, ArrayList<List<LinksetNode>> linksets) {
        Iterator<Bitstream> bitstreamsIterator = this.getItemBitstreams(context, item);
        bitstreamsIterator.forEachRemaining(bitstream -> {
            try {
                boolean isAuthorized = this.bitstreamMetadataReadPermissionEvaluatorPlugin.metadataReadPermissionOnBitstream(context, (Bitstream)bitstream);
                if (isAuthorized) {
                    ArrayList<LinksetNode> bitstreamLinkset = new ArrayList<LinksetNode>();
                    for (BitstreamSignpostingProcessor processor : this.bitstreamProcessors) {
                        processor.addLinkSetNodes(context, request, bitstream, bitstreamLinkset);
                    }
                    if (!bitstreamLinkset.isEmpty()) {
                        linksets.add(bitstreamLinkset);
                    }
                }
            }
            catch (SQLException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        });
    }

    private void addMetadataLinksets(HttpServletRequest request, Context context, Item item, ArrayList<List<LinksetNode>> linksets) {
        for (MetadataSignpostingProcessor processor : this.metadataProcessors) {
            ArrayList<LinksetNode> metadataLinkset = new ArrayList<LinksetNode>();
            processor.addLinkSetNodes(context, request, item, metadataLinkset);
            if (metadataLinkset.isEmpty()) continue;
            linksets.add(metadataLinkset);
        }
    }

    private Iterator<Bitstream> getItemBitstreams(Context context, Item item) {
        try {
            List bundles = this.itemService.getBundles(item, "ORIGINAL");
            return bundles.stream().flatMap(bundle -> bundle.getBitstreams().stream()).iterator();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private int countItemBitstreams(Item item) {
        try {
            int countBitstreams = 0;
            List bundles = this.itemService.getBundles(item, "ORIGINAL");
            for (Bundle bundle : bundles) {
                countBitstreams += bundle.getBitstreams().size();
            }
            return countBitstreams;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

