/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository.patch.operation;

import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.repository.patch.operation.PatchOperation;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.springframework.stereotype.Component;

@Component
public class EPersonLoginReplaceOperation<R>
extends PatchOperation<R> {
    private static final String OPERATION_PATH_CANLOGIN = "/canLogin";

    @Override
    public R perform(Context context, R object, Operation operation) {
        this.checkOperationValue(operation.getValue());
        Boolean canLogin = this.getBooleanOperationValue(operation.getValue());
        if (this.supports(object, operation)) {
            EPerson eperson = (EPerson)object;
            eperson.setCanLogIn(canLogin.booleanValue());
            return object;
        }
        throw new DSpaceBadRequestException("EPersonLoginReplaceOperation does not support this operation");
    }

    @Override
    public boolean supports(Object objectToMatch, Operation operation) {
        return objectToMatch instanceof EPerson && operation.getOp().trim().equalsIgnoreCase("replace") && operation.getPath().trim().equalsIgnoreCase(OPERATION_PATH_CANLOGIN);
    }
}

