/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import jakarta.servlet.http.HttpServletRequest;
import java.sql.SQLException;
import javax.annotation.Nullable;
import org.dspace.app.rest.model.CollectionRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.AbstractDSpaceRestRepository;
import org.dspace.app.rest.repository.LinkRestRepository;
import org.dspace.core.Context;
import org.dspace.workflow.WorkflowItem;
import org.dspace.xmlworkflow.storedcomponents.service.XmlWorkflowItemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="workflow.workflowitems.collection")
public class WorkflowItemCollectionLinkRepository
extends AbstractDSpaceRestRepository
implements LinkRestRepository {
    @Autowired
    XmlWorkflowItemService wis;

    @PreAuthorize(value="hasPermission(#id, 'WORKFLOWITEM', 'READ')")
    public CollectionRest getWorkflowItemCollection(@Nullable HttpServletRequest request, Integer id, @Nullable Pageable optionalPageable, Projection projection) {
        try {
            Context context = this.obtainContext();
            WorkflowItem witem = this.wis.find(context, id.intValue());
            if (witem == null) {
                throw new ResourceNotFoundException("No such workflow item: " + id);
            }
            return (CollectionRest)this.converter.toRest(witem.getCollection(), projection);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

