/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.util.List;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.Parameter;
import org.dspace.app.rest.SearchRestMethod;
import org.dspace.app.rest.exception.RepositoryMethodNotImplementedException;
import org.dspace.app.rest.model.SuggestionRest;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.app.suggestion.Suggestion;
import org.dspace.app.suggestion.SuggestionService;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="integration.suggestions")
public class SuggestionRestRepository
extends DSpaceRestRepository<SuggestionRest, String> {
    private static final String ORDER_FIELD = "trust";
    private static final Logger log = LogManager.getLogger(SuggestionRestRepository.class);
    @Autowired
    private SuggestionService suggestionService;

    @Override
    @PreAuthorize(value="hasPermission(#id, 'SUGGESTION', 'READ')")
    public SuggestionRest findOne(Context context, String id) {
        Suggestion suggestion = this.suggestionService.findUnprocessedSuggestion(context, id);
        if (suggestion == null) {
            return null;
        }
        return (SuggestionRest)this.converter.toRest(suggestion, this.utils.obtainProjection());
    }

    @Override
    @PreAuthorize(value="permitAll()")
    public Page<SuggestionRest> findAll(Context context, Pageable pageable) {
        throw new RepositoryMethodNotImplementedException("suggestiontarget", "findAll");
    }

    @PreAuthorize(value="hasPermission(#target, 'SUGGESTION.TARGET', 'READ')")
    @SearchRestMethod(name="findByTargetAndSource")
    public Page<SuggestionRest> findByTargetAndSource(@Parameter(required=true, value="source") String source, @Parameter(required=true, value="target") UUID target, Pageable pageable) {
        Context context = this.obtainContext();
        boolean ascending = false;
        if (pageable.getSort() != null && pageable.getSort().getOrderFor(ORDER_FIELD) != null) {
            ascending = pageable.getSort().getOrderFor(ORDER_FIELD).getDirection() == Sort.Direction.ASC;
        }
        List suggestions = this.suggestionService.findByTargetAndSource(context, target, source, pageable.getPageSize(), pageable.getOffset(), ascending);
        long tot = this.suggestionService.countAllByTargetAndSource(context, source, target);
        return this.converter.toRestPage(suggestions, pageable, tot, this.utils.obtainProjection());
    }

    @Override
    @PreAuthorize(value="hasPermission(#id, 'SUGGESTION', 'DELETE')")
    protected void delete(Context context, String id) throws AuthorizeException, RepositoryMethodNotImplementedException {
        this.suggestionService.rejectSuggestion(context, id);
    }

    @Override
    public Class<SuggestionRest> getDomainClass() {
        return SuggestionRest.class;
    }
}

