/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.Parameter;
import org.dspace.app.rest.SearchRestMethod;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.MetadataFieldRest;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchema;
import org.dspace.content.NonUniqueMetadataException;
import org.dspace.content.service.MetadataFieldService;
import org.dspace.content.service.MetadataSchemaService;
import org.dspace.core.Context;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.DiscoverResult;
import org.dspace.discovery.IndexableObject;
import org.dspace.discovery.SearchService;
import org.dspace.discovery.SearchServiceException;
import org.dspace.discovery.indexobject.IndexableMetadataField;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="core.metadatafields")
public class MetadataFieldRestRepository
extends DSpaceRestRepository<MetadataFieldRest, Integer> {
    private static Logger log = LogManager.getLogger(MetadataFieldRestRepository.class);
    @Autowired
    MetadataFieldService metadataFieldService;
    @Autowired
    MetadataSchemaService metadataSchemaService;
    @Autowired
    private SearchService searchService;

    @Override
    @PreAuthorize(value="permitAll()")
    public MetadataFieldRest findOne(Context context, Integer id) {
        MetadataField metadataField = null;
        try {
            metadataField = this.metadataFieldService.find(context, id.intValue());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (metadataField == null) {
            return null;
        }
        return (MetadataFieldRest)this.converter.toRest(metadataField, this.utils.obtainProjection());
    }

    @Override
    public Page<MetadataFieldRest> findAll(Context context, Pageable pageable) {
        try {
            List metadataFields = this.metadataFieldService.findAll(context);
            return this.converter.toRestPage(metadataFields, pageable, this.utils.obtainProjection());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @SearchRestMethod(name="bySchema")
    public Page<MetadataFieldRest> findBySchema(@Parameter(value="schema", required=true) String schemaName, Pageable pageable) {
        try {
            Context context = this.obtainContext();
            MetadataSchema schema = this.metadataSchemaService.find(context, schemaName);
            if (schema == null) {
                return null;
            }
            List metadataFields = this.metadataFieldService.findAllInSchema(context, schema);
            return this.converter.toRestPage(metadataFields, pageable, this.utils.obtainProjection());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @SearchRestMethod(name="byFieldName")
    public Page<MetadataFieldRest> findByFieldName(@Parameter(value="schema", required=false) String schemaName, @Parameter(value="element", required=false) String elementName, @Parameter(value="qualifier", required=false) String qualifierName, @Parameter(value="query", required=false) String query, @Parameter(value="exactName", required=false) String exactName, Pageable pageable) throws SQLException {
        Context context = this.obtainContext();
        long totalElements = 0L;
        ArrayList<MetadataField> matchingMetadataFields = new ArrayList<MetadataField>();
        if (StringUtils.isBlank((CharSequence)exactName)) {
            DiscoverQuery discoverQuery = this.createDiscoverQuery(context, schemaName, elementName, qualifierName, query, pageable);
            try {
                DiscoverResult searchResult = this.searchService.search(context, null, discoverQuery);
                for (IndexableObject object : searchResult.getIndexableObjects()) {
                    if (!(object instanceof IndexableMetadataField)) continue;
                    matchingMetadataFields.add(((IndexableMetadataField)object).getIndexedObject());
                }
                totalElements = searchResult.getTotalSearchResults();
            }
            catch (SearchServiceException e) {
                log.error("Error while searching with Discovery", (Throwable)e);
                throw new IllegalArgumentException("Error while searching with Discovery: " + e.getMessage());
            }
        } else {
            if (StringUtils.isNotBlank((CharSequence)elementName) || StringUtils.isNotBlank((CharSequence)qualifierName) || StringUtils.isNotBlank((CharSequence)schemaName) || StringUtils.isNotBlank((CharSequence)query)) {
                throw new UnprocessableEntityException("Use either exactName or a combination of element, qualifier and schema to search discovery for metadata fields");
            }
            MetadataField exactMatchingMdField = this.metadataFieldService.findByString(context, exactName, '.');
            if (exactMatchingMdField != null) {
                matchingMetadataFields.add(exactMatchingMdField);
                totalElements = 1L;
            }
        }
        return this.converter.toRestPage(matchingMetadataFields, pageable, totalElements, this.utils.obtainProjection());
    }

    private DiscoverQuery createDiscoverQuery(Context context, String schemaName, String elementName, String qualifierName, String query, Pageable pageable) throws SQLException {
        ArrayList<Object> filterQueries = new ArrayList<Object>();
        if (StringUtils.isNotBlank((CharSequence)query)) {
            if (query.split("\\.").length > 3) {
                throw new IllegalArgumentException("Query param should not contain more than 2 dot (.) separators, forming schema.element.qualifier metadata field name");
            }
            filterQueries.add(this.searchService.toFilterQuery(context, "fieldName", "equals", query, null).getFilterQuery() + "*");
        }
        if (StringUtils.isNotBlank((CharSequence)schemaName)) {
            filterQueries.add(this.searchService.toFilterQuery(context, "schema", "equals", schemaName, null).getFilterQuery());
        }
        if (StringUtils.isNotBlank((CharSequence)elementName)) {
            filterQueries.add(this.searchService.toFilterQuery(context, "element", "equals", elementName, null).getFilterQuery());
        }
        if (StringUtils.isNotBlank((CharSequence)qualifierName)) {
            filterQueries.add(this.searchService.toFilterQuery(context, "qualifier", "equals", qualifierName, null).getFilterQuery());
        }
        DiscoverQuery discoverQuery = new DiscoverQuery();
        discoverQuery.addFilterQueries(filterQueries.toArray(new String[filterQueries.size()]));
        Iterator orderIterator = pageable.getSort().iterator();
        if (orderIterator.hasNext()) {
            Sort.Order order = (Sort.Order)orderIterator.next();
            discoverQuery.setSortField(order.getProperty() + "_sort", order.getDirection() == Sort.Direction.ASC ? DiscoverQuery.SORT_ORDER.asc : DiscoverQuery.SORT_ORDER.desc);
        }
        discoverQuery.setStart(Math.toIntExact(pageable.getOffset()));
        discoverQuery.setMaxResults(pageable.getPageSize());
        return discoverQuery;
    }

    @Override
    public Class<MetadataFieldRest> getDomainClass() {
        return MetadataFieldRest.class;
    }

    @Override
    @PreAuthorize(value="hasAuthority('ADMIN')")
    protected MetadataFieldRest createAndReturn(Context context) throws AuthorizeException, SQLException {
        MetadataField metadataField;
        MetadataFieldRest metadataFieldRest;
        try {
            metadataFieldRest = (MetadataFieldRest)new ObjectMapper().readValue((InputStream)this.getRequestService().getCurrentRequest().getHttpServletRequest().getInputStream(), MetadataFieldRest.class);
        }
        catch (IOException excIO) {
            throw new DSpaceBadRequestException("error parsing request body", excIO);
        }
        String schemaId = this.getRequestService().getCurrentRequest().getHttpServletRequest().getParameter("schemaId");
        if (StringUtils.isBlank((CharSequence)schemaId)) {
            throw new UnprocessableEntityException("metadata schema ID cannot be blank");
        }
        MetadataSchema schema = this.metadataSchemaService.find(context, Integer.parseInt(schemaId));
        if (schema == null) {
            throw new UnprocessableEntityException("metadata schema with ID " + schemaId + " not found");
        }
        if (StringUtils.isBlank((CharSequence)metadataFieldRest.getElement())) {
            throw new UnprocessableEntityException("metadata element (in request body) cannot be blank");
        }
        if (!metadataFieldRest.getElement().matches("^[^. ,]{1,64}$")) {
            throw new UnprocessableEntityException("metadata element (in request body) cannot contain dots, commas or spaces and should be smaller than 64 characters");
        }
        if (StringUtils.isBlank((CharSequence)metadataFieldRest.getQualifier())) {
            metadataFieldRest.setQualifier(null);
        } else if (!metadataFieldRest.getQualifier().matches("^[^. ,]{1,64}$")) {
            throw new UnprocessableEntityException("metadata qualifier (in request body) cannot contain dots, commas or spaces and should be smaller than 64 characters");
        }
        try {
            metadataField = this.metadataFieldService.create(context, schema, metadataFieldRest.getElement(), metadataFieldRest.getQualifier(), metadataFieldRest.getScopeNote());
            this.metadataFieldService.update(context, metadataField);
        }
        catch (NonUniqueMetadataException e) {
            throw new UnprocessableEntityException("metadata field " + schema.getName() + "." + metadataFieldRest.getElement() + (String)(metadataFieldRest.getQualifier() != null ? "." + metadataFieldRest.getQualifier() : "") + " already exists");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return (MetadataFieldRest)this.converter.toRest(metadataField, this.utils.obtainProjection());
    }

    @Override
    @PreAuthorize(value="hasAuthority('ADMIN')")
    protected void delete(Context context, Integer id) throws AuthorizeException {
        try {
            MetadataField metadataField = this.metadataFieldService.find(context, id.intValue());
            if (metadataField == null) {
                throw new ResourceNotFoundException("metadata field with id: " + id + " not found");
            }
            this.metadataFieldService.delete(context, metadataField);
        }
        catch (SQLException e) {
            throw new RuntimeException("error while trying to delete metadatafield with id: " + id, e);
        }
    }

    @Override
    @PreAuthorize(value="hasAuthority('ADMIN')")
    protected MetadataFieldRest put(Context context, HttpServletRequest request, String apiCategory, String model, Integer id, JsonNode jsonNode) throws SQLException, AuthorizeException {
        MetadataFieldRest metadataFieldRest;
        try {
            metadataFieldRest = (MetadataFieldRest)new ObjectMapper().readValue(jsonNode.toString(), MetadataFieldRest.class);
        }
        catch (JsonProcessingException e) {
            throw new DSpaceBadRequestException("Cannot parse JSON in request body", (Exception)((Object)e));
        }
        MetadataField metadataField = this.metadataFieldService.find(context, id.intValue());
        if (metadataField == null) {
            throw new UnprocessableEntityException("metadata field with id: " + id + " not found");
        }
        if (!Objects.equals(metadataFieldRest.getElement(), metadataField.getElement())) {
            throw new UnprocessableEntityException("Metadata element cannot be updated.");
        }
        if (!Objects.equals(metadataFieldRest.getQualifier(), metadataField.getQualifier())) {
            throw new UnprocessableEntityException("Metadata qualifier cannot be updated.");
        }
        if (!Objects.equals(id, metadataFieldRest.getId())) {
            throw new UnprocessableEntityException("ID in request body doesn't match path ID");
        }
        metadataField.setScopeNote(metadataFieldRest.getScopeNote());
        try {
            this.metadataFieldService.update(context, metadataField);
            context.commit();
        }
        catch (NonUniqueMetadataException e) {
            throw new UnprocessableEntityException("metadata field " + metadataField.getMetadataSchema().getName() + "." + metadataFieldRest.getElement() + (String)(metadataFieldRest.getQualifier() != null ? "." + metadataFieldRest.getQualifier() : "") + " already exists");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return (MetadataFieldRest)this.converter.toRest(metadataField, this.utils.obtainProjection());
    }
}

