/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.dspace.contentreport.Filter;
import org.dspace.contentreport.FilteredCollection;

public class FilteredCollectionRest {
    public static final String NAME = "filtered-collection";
    public static final String CATEGORY = "contentreport";
    private String label;
    private String handle;
    @JsonProperty(value="community_label")
    private String communityLabel;
    @JsonProperty(value="community_handle")
    private String communityHandle;
    @JsonProperty(value="nb_total_items")
    private int totalItems;
    private Map<Filter, Integer> values = new EnumMap<Filter, Integer>(Filter.class);
    @JsonProperty(value="all_filters_value")
    private int allFiltersValue;

    public static FilteredCollectionRest of(FilteredCollection model) {
        Objects.requireNonNull(model);
        FilteredCollectionRest coll = new FilteredCollectionRest();
        coll.label = model.getLabel();
        coll.handle = model.getHandle();
        coll.communityLabel = model.getCommunityLabel();
        coll.communityHandle = model.getCommunityHandle();
        coll.totalItems = model.getTotalItems();
        coll.allFiltersValue = model.getAllFiltersValue();
        Optional.ofNullable(model.getValues()).ifPresent(coll.values::putAll);
        return coll;
    }

    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    public String getType() {
        return NAME;
    }

    public Map<Filter, Integer> getValues() {
        return this.values;
    }

    public String getLabel() {
        return this.label;
    }

    public String getHandle() {
        return this.handle;
    }

    public String getCommunityLabel() {
        return this.communityLabel;
    }

    public String getCommunityHandle() {
        return this.communityHandle;
    }

    public int getTotalItems() {
        return this.totalItems;
    }

    public int getAllFiltersValue() {
        return this.allFiltersValue;
    }
}

