/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dspace.app.rest.converter.HarvestedCollectionConverter;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.HarvestTypeEnum;
import org.dspace.app.rest.model.HarvestedCollectionRest;
import org.dspace.app.rest.repository.AbstractDSpaceRestRepository;
import org.dspace.content.Collection;
import org.dspace.core.Context;
import org.dspace.harvest.HarvestedCollection;
import org.dspace.harvest.OAIHarvester;
import org.dspace.harvest.service.HarvestedCollectionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="core.harvestedcollections")
public class HarvestedCollectionRestRepository
extends AbstractDSpaceRestRepository {
    @Autowired
    HarvestedCollectionService harvestedCollectionService;
    @Autowired
    HarvestedCollectionConverter harvestedCollectionConverter;

    public HarvestedCollectionRest findOne(Collection collection) throws SQLException {
        Context context = this.obtainContext();
        if (collection == null) {
            return null;
        }
        HarvestedCollection harvestedCollection = this.harvestedCollectionService.find(context, collection);
        List configs = OAIHarvester.getAvailableMetadataFormats();
        return this.harvestedCollectionConverter.fromModel(harvestedCollection, collection, configs, this.utils.obtainProjection());
    }

    public HarvestedCollectionRest update(Context context, HttpServletRequest request, Collection collection) throws SQLException {
        HarvestedCollectionRest harvestedCollectionRest = this.parseHarvestedCollectionRest(context, request, collection);
        HarvestedCollection harvestedCollection = this.harvestedCollectionService.find(context, collection);
        if (harvestedCollectionRest.getHarvestType() == HarvestTypeEnum.NONE.getValue() && harvestedCollection != null) {
            this.harvestedCollectionService.delete(context, harvestedCollection);
            return this.harvestedCollectionConverter.convert(null, this.utils.obtainProjection());
        }
        if (harvestedCollectionRest.getHarvestType() != HarvestTypeEnum.NONE.getValue()) {
            List<String> errors = this.testHarvestSettings(harvestedCollectionRest);
            if (errors.size() == 0) {
                if (harvestedCollection == null) {
                    harvestedCollection = this.harvestedCollectionService.create(context, collection);
                }
                this.updateCollectionHarvestSettings(context, harvestedCollection, harvestedCollectionRest);
                harvestedCollection = this.harvestedCollectionService.find(context, collection);
                List configs = OAIHarvester.getAvailableMetadataFormats();
                return this.harvestedCollectionConverter.fromModel(harvestedCollection, collection, configs, this.utils.obtainProjection());
            }
            throw new UnprocessableEntityException("Incorrect harvest settings in request. The following errors were found: " + errors.toString());
        }
        return null;
    }

    private HarvestedCollectionRest parseHarvestedCollectionRest(Context context, HttpServletRequest request, Collection collection) throws SQLException {
        HarvestedCollectionRest harvestedCollectionRest;
        ObjectMapper mapper = new ObjectMapper();
        try {
            ServletInputStream input = request.getInputStream();
            harvestedCollectionRest = (HarvestedCollectionRest)mapper.readValue((InputStream)input, HarvestedCollectionRest.class);
        }
        catch (IOException e) {
            throw new UnprocessableEntityException("Error parsing request body: " + e.toString(), e);
        }
        return harvestedCollectionRest;
    }

    private void updateCollectionHarvestSettings(Context context, HarvestedCollection harvestedCollection, HarvestedCollectionRest harvestedCollectionRest) throws SQLException {
        int harvestType = harvestedCollectionRest.getHarvestType();
        String oaiSource = harvestedCollectionRest.getOaiSource();
        String oaiSetId = harvestedCollectionRest.getOaiSetId();
        String metadataConfigId = harvestedCollectionRest.getMetadataConfigId();
        harvestedCollection.setHarvestType(harvestType);
        harvestedCollection.setOaiSource(oaiSource);
        harvestedCollection.setOaiSetId(oaiSetId);
        harvestedCollection.setHarvestMetadataConfig(metadataConfigId);
        this.harvestedCollectionService.update(context, harvestedCollection);
    }

    private List<String> testHarvestSettings(HarvestedCollectionRest harvestedCollectionRest) {
        boolean inAvailableMetadataFormats;
        int harvestType = harvestedCollectionRest.getHarvestType();
        String metadataConfigId = harvestedCollectionRest.getMetadataConfigId();
        List<String> errors = new ArrayList<String>();
        List metadataFormats = OAIHarvester.getAvailableMetadataFormats();
        boolean bl = inAvailableMetadataFormats = metadataFormats.stream().filter(x -> ((String)x.get("id")).equals(metadataConfigId)).count() >= 1L;
        if (inAvailableMetadataFormats) {
            boolean testORE = Arrays.asList(HarvestTypeEnum.METADATA_AND_REF.getValue(), HarvestTypeEnum.METADATA_AND_BITSTREAMS.getValue()).contains(harvestType);
            List verificationErrors = this.harvestedCollectionService.verifyOAIharvester(harvestedCollectionRest.getOaiSource(), harvestedCollectionRest.getOaiSetId(), metadataConfigId, testORE);
            errors = verificationErrors;
        } else {
            errors.add("The metadata format with identifier '" + metadataConfigId + "' is not an available metadata format.");
        }
        return errors;
    }
}

