/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.util.Authenticate;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.authenticate.AuthenticationManager;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.dspace.core.LogManager;

public class ShibbolethServlet
extends DSpaceServlet {
    private static Logger log = Logger.getLogger(ShibbolethServlet.class);

    @Override
    protected void doDSGet(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = names.nextElement().toString();
            log.info((Object)("header:" + name + "=" + request.getHeader(name)));
        }
        String jsp = null;
        int status = AuthenticationManager.authenticate((Context)context, null, null, null, (HttpServletRequest)request);
        if (status == 1) {
            Authenticate.loggedIn(context, request, context.getCurrentUser());
            log.info((Object)LogManager.getHeader((Context)context, (String)"login", (String)"type=shibboleth"));
            Authenticate.resumeInterruptedRequest(request, response);
            return;
        }
        if (status == 3) {
            jsp = "/error/require-certificate.jsp";
        } else if (status == 4) {
            jsp = "/login/no-single-sign-out.jsp";
        } else if (status == 5) {
            jsp = "/login/no-email.jsp";
        }
        log.info((Object)LogManager.getHeader((Context)context, (String)"failed_login", (String)("result=" + String.valueOf(status))));
        JSPManager.showJSP(request, response, jsp);
    }
}

