/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.versioning.dao.impl;

import jakarta.persistence.Query;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import org.dspace.content.Item;
import org.dspace.core.AbstractHibernateDAO;
import org.dspace.core.Context;
import org.dspace.versioning.Version;
import org.dspace.versioning.VersionHistory;
import org.dspace.versioning.Version_;
import org.dspace.versioning.dao.VersionDAO;

public class VersionDAOImpl
extends AbstractHibernateDAO<Version>
implements VersionDAO {
    protected VersionDAOImpl() {
    }

    @Override
    public Version findByItem(Context context, Item item) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<Version> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, Version.class);
        Root versionRoot = criteriaQuery.from(Version.class);
        criteriaQuery.select((Selection)versionRoot);
        criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)versionRoot.get(Version_.item), (Object)item));
        return (Version)this.singleResult(context, criteriaQuery);
    }

    @Override
    public int getNextVersionNumber(Context c, VersionHistory vh) throws SQLException {
        Query q = this.createQuery(c, "SELECT (COALESCE(MAX(versionNumber), 0) + 1) FROM Version WHERE versionHistory.id = :historyId");
        q.setParameter("historyId", (Object)vh.getID());
        int next = (Integer)q.getSingleResult();
        return next;
    }

    @Override
    public List<Version> findVersionsWithItems(Context context, VersionHistory versionHistory, int offset, int limit) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<Version> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, Version.class);
        Root versionRoot = criteriaQuery.from(Version.class);
        criteriaQuery.select((Selection)versionRoot);
        criteriaQuery.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)versionRoot.get(Version_.versionHistory), (Object)versionHistory), (Expression)criteriaBuilder.isNotNull((Expression)versionRoot.get(Version_.item))));
        LinkedList<Order> orderList = new LinkedList<Order>();
        orderList.add(criteriaBuilder.desc((Expression)versionRoot.get(Version_.versionNumber)));
        criteriaQuery.orderBy(orderList);
        return this.list(context, criteriaQuery, false, Version.class, limit, offset);
    }

    @Override
    public int countVersionsByHistoryWithItem(Context context, VersionHistory versionHistory) throws SQLException {
        Query query = this.createQuery(context, "SELECT count(*) FROM " + Version.class.getSimpleName() + " WHERE versionHistory = :versionhistory AND  item IS NOT NULL");
        query.setParameter("versionhistory", (Object)versionHistory);
        return this.count(query);
    }
}

