/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.metadatamapping.contributor;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.importer.external.metadatamapping.contributor.JsonPathMetadataProcessor;

public class ConditionalArrayElementAttributeProcessor
implements JsonPathMetadataProcessor {
    private static final Logger log = LogManager.getLogger();
    private String pathToArray;
    private String elementAttribute;
    private String filterAttribute;
    private String requiredValueInFilter;

    @Override
    public Collection<String> processMetadata(String json) {
        JsonNode rootNode = this.convertStringJsonToJsonNode(json);
        ArrayList<String> results = new ArrayList<String>();
        if (rootNode == null) {
            return results;
        }
        for (JsonNode element : rootNode.at(this.pathToArray)) {
            JsonNode filterNode = element.at(this.filterAttribute);
            boolean match = false;
            if (filterNode.isArray()) {
                for (JsonNode filterValue : filterNode) {
                    if (!this.requiredValueInFilter.equalsIgnoreCase(filterValue.textValue())) continue;
                    match = true;
                    break;
                }
            } else if (filterNode.isTextual() && this.requiredValueInFilter.equalsIgnoreCase(filterNode.textValue())) {
                match = true;
            }
            if (!match) continue;
            JsonNode valueNode = element.at(this.elementAttribute);
            if (valueNode.isTextual()) {
                results.add(valueNode.textValue());
                continue;
            }
            if (!valueNode.isArray()) continue;
            for (JsonNode item : valueNode) {
                if (!item.isTextual() || !StringUtils.isNotBlank((CharSequence)item.textValue())) continue;
                results.add(item.textValue());
            }
        }
        return results;
    }

    private JsonNode convertStringJsonToJsonNode(String json) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.readTree(json);
        }
        catch (JsonProcessingException e) {
            log.error("Unable to process JSON response.", (Throwable)e);
            return null;
        }
    }

    public void setPathToArray(String pathToArray) {
        this.pathToArray = pathToArray;
    }

    public void setElementAttribute(String elementAttribute) {
        this.elementAttribute = elementAttribute;
    }

    public void setFilterAttribute(String filterAttribute) {
        this.filterAttribute = filterAttribute;
    }

    public void setRequiredValueInFilter(String requiredValueInFilter) {
        this.requiredValueInFilter = requiredValueInFilter;
    }
}

