/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.disseminate;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.RandomAccessReadBuffer;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Bitstream;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.disseminate.CoverPageService;
import org.dspace.disseminate.service.CitationDocumentService;
import org.dspace.handle.service.HandleService;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class CitationDocumentServiceImpl
implements CitationDocumentService,
InitializingBean {
    private static final Logger log = LogManager.getLogger(CitationDocumentServiceImpl.class);
    protected final Set<String> VALID_TYPES = new HashSet<String>(2);
    protected final Set<String> PDF_MIMES = new HashSet<String>(2);
    protected final Set<String> RASTER_MIMES = new HashSet<String>();
    protected final Set<String> SVG_MIMES = new HashSet<String>();
    protected List<String> citationEnabledCollectionsList;
    protected File tempDir;
    @Autowired(required=true)
    protected AuthorizeService authorizeService;
    @Autowired(required=true)
    protected BitstreamService bitstreamService;
    @Autowired(required=true)
    protected CommunityService communityService;
    @Autowired(required=true)
    protected ItemService itemService;
    @Autowired(required=true)
    protected ConfigurationService configurationService;
    @Autowired(required=true)
    protected HandleService handleService;
    @Autowired
    CoverPageService coverPageService;
    protected Boolean citationEnabledGlobally = null;
    protected Boolean citationAsFirstPage = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws Exception {
        this.SVG_MIMES.add("image/jpeg");
        this.SVG_MIMES.add("image/pjpeg");
        this.SVG_MIMES.add("image/png");
        this.SVG_MIMES.add("image/gif");
        this.SVG_MIMES.add("image/svg");
        this.SVG_MIMES.add("image/svg+xml");
        this.PDF_MIMES.add("application/pdf");
        this.PDF_MIMES.add("application/x-pdf");
        this.VALID_TYPES.addAll(this.PDF_MIMES);
        this.citationEnabledGlobally = this.configurationService.getBooleanProperty("citation-page.enable_globally", false);
        String[] citationEnabledCollections = this.configurationService.getArrayProperty("citation-page.enabled_collections");
        this.citationEnabledCollectionsList = new ArrayList<String>(Arrays.asList(citationEnabledCollections));
        String[] citationEnabledCommunities = this.configurationService.getArrayProperty("citation-page.enabled_communities");
        if (this.citationEnabledCollectionsList == null) {
            this.citationEnabledCollectionsList = new ArrayList<String>();
        }
        if (citationEnabledCommunities != null && citationEnabledCommunities.length > 0) {
            Context context = null;
            try {
                context = new Context();
                for (String communityString : citationEnabledCommunities) {
                    DSpaceObject dsoCommunity = this.handleService.resolveToObject(context, communityString.trim());
                    if (dsoCommunity instanceof Community) {
                        Community community = (Community)dsoCommunity;
                        List<Collection> collections = this.communityService.getAllCollections(context, community);
                        for (Collection collection : collections) {
                            this.citationEnabledCollectionsList.add(collection.getHandle());
                        }
                        continue;
                    }
                    log.error("Invalid community for citation.enabled_communities, value:" + communityString.trim());
                }
            }
            catch (SQLException e) {
                log.error(e.getMessage());
            }
            finally {
                if (context != null) {
                    context.abort();
                }
            }
        }
        String tempDirString = this.configurationService.getProperty("dspace.dir") + File.separator + "temp";
        this.tempDir = new File(tempDirString);
        if (!this.tempDir.exists()) {
            boolean success = this.tempDir.mkdir();
            if (success) {
                log.info("Created temp directory at: " + tempDirString);
            } else {
                log.info("Unable to create temp directory at: " + tempDirString);
            }
        }
    }

    protected CitationDocumentServiceImpl() {
    }

    protected boolean isCitationEnabledGlobally() {
        return this.citationEnabledGlobally;
    }

    protected boolean isCitationEnabledThroughCollection(Context context, Bitstream bitstream) throws SQLException {
        if (this.citationEnabledCollectionsList.isEmpty()) {
            return false;
        }
        DSpaceObject owningDSO = this.bitstreamService.getParentObject(context, bitstream);
        if (owningDSO instanceof Item) {
            Item item = (Item)owningDSO;
            List<Collection> collections = item.getCollections();
            for (Collection collection : collections) {
                if (!this.citationEnabledCollectionsList.contains(collection.getHandle())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Boolean isCitationEnabledForBitstream(Bitstream bitstream, Context context) throws SQLException {
        boolean adminUser;
        if ((this.isCitationEnabledGlobally() || this.isCitationEnabledThroughCollection(context, bitstream)) && !(adminUser = this.authorizeService.isAdmin(context)) && this.canGenerateCitationVersion(context, bitstream)) {
            return true;
        }
        return false;
    }

    protected Boolean isCitationFirstPage() {
        if (this.citationAsFirstPage == null) {
            this.citationAsFirstPage = this.configurationService.getBooleanProperty("citation-page.citation_as_first_page", true);
        }
        return this.citationAsFirstPage;
    }

    @Override
    public boolean canGenerateCitationVersion(Context context, Bitstream bitstream) throws SQLException {
        return this.VALID_TYPES.contains(bitstream.getFormat(context).getMIMEType());
    }

    /*
     * Exception decompiling
     */
    @Override
    public Pair<byte[], Long> makeCitedDocument(Context context, Bitstream bitstream) throws IOException, SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private PDDocument loadDocumentFromDB(Context context, Bitstream bitstream) {
        PDDocument pDDocument;
        block8: {
            InputStream inputStream = this.bitstreamService.retrieve(context, bitstream);
            try {
                pDDocument = Loader.loadPDF((RandomAccessRead)new RandomAccessReadBuffer(inputStream));
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | SQLException | AuthorizeException e) {
                    throw new RuntimeException(e);
                }
            }
            inputStream.close();
        }
        return pDDocument;
    }

    private static Pair<byte[], Long> documentAsBytes(PDDocument document) throws IOException {
        document.setAllSecurityToBeRemoved(true);
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            document.save((OutputStream)out);
            byte[] data = out.toByteArray();
            Pair pair = Pair.of((Object)data, (Object)data.length);
            return pair;
        }
    }

    private void addCoverPageToDocument(PDDocument document, PDDocument sourceDocument, PDDocument coverPage) {
        PDPageTree sourcePages = sourceDocument.getDocumentCatalog().getPages();
        PDPageTree coverPages = coverPage.getDocumentCatalog().getPages();
        if (this.isCitationFirstPage().booleanValue()) {
            for (PDPage page : coverPages) {
                document.addPage(page);
            }
            for (PDPage sourcePage : sourcePages) {
                document.addPage(sourcePage);
            }
        } else {
            for (PDPage sourcePage : sourcePages) {
                document.addPage(sourcePage);
            }
            for (PDPage page : coverPages) {
                document.addPage(page);
            }
        }
    }
}

