/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authority.indexer;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authority.AuthorityValue;
import org.dspace.authority.factory.AuthorityServiceFactory;
import org.dspace.authority.indexer.AuthorityIndexerInterface;
import org.dspace.authority.indexer.AuthorityIndexingService;
import org.dspace.authority.service.AuthorityService;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;

public class AuthorityIndexClient {
    private static Logger log = LogManager.getLogger(AuthorityIndexClient.class);
    protected static final AuthorityService authorityService = AuthorityServiceFactory.getInstance().getAuthorityService();
    protected static final AuthorityIndexingService indexingService = AuthorityServiceFactory.getInstance().getAuthorityIndexingService();
    protected static final List<AuthorityIndexerInterface> indexers = AuthorityServiceFactory.getInstance().getAuthorityIndexers();
    protected static final ItemService itemService = ContentServiceFactory.getInstance().getItemService();

    private AuthorityIndexClient() {
    }

    public static void main(String[] args) throws Exception {
        Context context = new Context();
        context.turnOffAuthorisationSystem();
        if (!authorityService.isConfigurationValid()) {
            System.out.println("Cannot index authority values since the configuration isn't valid. Check dspace logs for more information.");
            return;
        }
        System.out.println("Retrieving all data");
        log.info("Retrieving all data");
        HashMap<String, AuthorityValue> toIndexValues = new HashMap<String, AuthorityValue>();
        for (AuthorityIndexerInterface indexerInterface : indexers) {
            log.info("Initialize " + indexerInterface.getClass().getName());
            System.out.println("Initialize " + indexerInterface.getClass().getName());
            Iterator<Item> allItems = itemService.findAll(context);
            HashMap<String, AuthorityValue> authorityCache = new HashMap<String, AuthorityValue>();
            while (allItems.hasNext()) {
                Item item = allItems.next();
                List<AuthorityValue> authorityValues = indexerInterface.getAuthorityValues(context, item, authorityCache);
                for (AuthorityValue authorityValue : authorityValues) {
                    toIndexValues.put(authorityValue.getId(), authorityValue);
                }
                context.uncacheEntity(item);
            }
        }
        log.info("Cleaning the old index");
        System.out.println("Cleaning the old index");
        indexingService.cleanIndex();
        log.info("Writing new data");
        System.out.println("Writing new data");
        for (String id : toIndexValues.keySet()) {
            indexingService.indexContent((AuthorityValue)toIndexValues.get(id));
            indexingService.commit();
        }
        indexingService.commit();
        context.complete();
        System.out.println("All done !");
        log.info("All done !");
    }
}

