/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.scripts.configuration;

import java.sql.SQLException;
import java.util.List;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.core.Context;
import org.dspace.scripts.DSpaceCommandLineParameter;
import org.dspace.scripts.DSpaceRunnable;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class ScriptConfiguration<T extends DSpaceRunnable>
implements BeanNameAware {
    @Autowired
    protected AuthorizeService authorizeService;
    protected Options options;
    private String description;
    private String name;

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public abstract Class<T> getDspaceRunnableClass();

    public abstract void setDspaceRunnableClass(Class<T> var1);

    public boolean isAllowedToExecute(Context context, List<DSpaceCommandLineParameter> commandLineParameters) {
        try {
            return this.authorizeService.isAdmin(context);
        }
        catch (SQLException e) {
            throw new RuntimeException("SQLException occurred when checking if the current user is an admin", e);
        }
    }

    public abstract Options getOptions();

    public Options getHelpOptions() {
        Options options = new Options();
        options.addOption(Option.builder((String)"h").longOpt("help").desc("help").hasArg(false).required(false).build());
        return options;
    }

    public void setBeanName(String beanName) {
        this.name = beanName;
    }
}

