/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.qaevent.dao.impl;

import jakarta.persistence.Query;
import java.sql.SQLException;
import java.time.Instant;
import java.util.List;
import org.dspace.content.Item;
import org.dspace.content.QAEventProcessed;
import org.dspace.core.AbstractHibernateDAO;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.qaevent.dao.QAEventsDAO;

public class QAEventsDAOImpl
extends AbstractHibernateDAO<QAEventProcessed>
implements QAEventsDAO {
    @Override
    public List<QAEventProcessed> findAll(Context context) throws SQLException {
        return this.findAll(context, QAEventProcessed.class);
    }

    @Override
    public boolean storeEvent(Context context, String checksum, EPerson eperson, Item item) {
        QAEventProcessed qaEvent = new QAEventProcessed();
        qaEvent.setEperson(eperson);
        qaEvent.setEventId(checksum);
        qaEvent.setItem(item);
        qaEvent.setEventTimestamp(Instant.now());
        try {
            this.create(context, qaEvent);
            return true;
        }
        catch (SQLException e) {
            return false;
        }
    }

    @Override
    public boolean isEventStored(Context context, String checksum) throws SQLException {
        Query query = this.createQuery(context, "SELECT count(eventId) FROM QAEventProcessed qaevent WHERE qaevent.eventId = :event_id ");
        query.setParameter("event_id", (Object)checksum);
        return this.count(query) != 0;
    }

    @Override
    public List<QAEventProcessed> searchByEventId(Context context, String eventId, Integer start, Integer size) throws SQLException {
        Query query = this.createQuery(context, "SELECT * FROM QAEventProcessed qaevent WHERE qaevent.qaevent_id = :event_id ");
        query.setFirstResult(start.intValue());
        query.setMaxResults(size.intValue());
        query.setParameter("event_id", (Object)eventId);
        return this.findMany(context, query);
    }

    @Override
    public List<QAEventProcessed> findByItem(Context context, Item item) throws SQLException {
        Query query = this.createQuery(context, " SELECT qaevent  FROM QAEventProcessed qaevent  WHERE qaevent.item = :item ");
        query.setParameter("item", (Object)item);
        return this.findMany(context, query);
    }

    @Override
    public List<QAEventProcessed> findByEPerson(Context context, EPerson ePerson) throws SQLException {
        Query query = this.createQuery(context, " SELECT qaevent  FROM QAEventProcessed qaevent  WHERE qaevent.eperson = :eperson ");
        query.setParameter("eperson", (Object)ePerson);
        return this.findMany(context, query);
    }
}

