/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.metadatamapping.contributor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.dspace.importer.external.metadatamapping.MetadataFieldConfig;
import org.dspace.importer.external.metadatamapping.MetadataFieldMapping;
import org.dspace.importer.external.metadatamapping.MetadatumDTO;
import org.dspace.importer.external.metadatamapping.contributor.MetadataContributor;

public class MultipleMetadataContributor<T>
implements MetadataContributor<T> {
    private MetadataFieldConfig field;
    private List<MetadataContributor> metadatumContributors;
    private boolean ensureUniqueValues;

    public MultipleMetadataContributor() {
    }

    public MultipleMetadataContributor(MetadataFieldConfig field, List<MetadataContributor> metadatumContributors) {
        this.field = field;
        this.metadatumContributors = metadatumContributors;
    }

    public MultipleMetadataContributor(MetadataFieldConfig field, List<MetadataContributor> metadatumContributors, boolean ensureUniqueValues) {
        this.field = field;
        this.metadatumContributors = metadatumContributors;
        this.ensureUniqueValues = ensureUniqueValues;
    }

    @Override
    public void setMetadataFieldMapping(MetadataFieldMapping<T, MetadataContributor<T>> metadataFieldMapping) {
        for (MetadataContributor metadatumContributor : this.metadatumContributors) {
            metadatumContributor.setMetadataFieldMapping(metadataFieldMapping);
        }
    }

    @Override
    public Collection<MetadatumDTO> contributeMetadata(T t) {
        Collection<MetadatumDTO> values = new ArrayList<MetadatumDTO>();
        for (MetadataContributor metadatumContributor : this.metadatumContributors) {
            Collection<MetadatumDTO> metadata = metadatumContributor.contributeMetadata(t);
            values.addAll(metadata);
        }
        this.changeDC(values);
        if (this.ensureUniqueValues) {
            values = values.stream().collect(Collectors.toMap(MetadatumDTO::getValue, dto -> dto, (existing, replacement) -> existing, LinkedHashMap::new)).values();
        }
        return values;
    }

    private void changeDC(Collection<MetadatumDTO> values) {
        for (MetadatumDTO dto : values) {
            dto.setElement(this.field.getElement());
            dto.setQualifier(this.field.getQualifier());
            dto.setSchema(this.field.getSchema());
        }
    }

    public MetadataFieldConfig getField() {
        return this.field;
    }

    public void setField(MetadataFieldConfig field) {
        this.field = field;
    }

    public List<MetadataContributor> getMetadatumContributors() {
        return this.metadatumContributors;
    }

    public void setMetadatumContributors(List<MetadataContributor> metadatumContributors) {
        this.metadatumContributors = metadatumContributors;
    }

    public boolean isEnsureUniqueValues() {
        return this.ensureUniqueValues;
    }

    public void setEnsureUniqueValues(boolean ensureUniqueValues) {
        this.ensureUniqueValues = ensureUniqueValues;
    }
}

