/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.metadatamapping.contributor;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.dspace.importer.external.metadatamapping.MetadataFieldConfig;
import org.dspace.importer.external.metadatamapping.MetadataFieldMapping;
import org.dspace.importer.external.metadatamapping.MetadatumDTO;
import org.dspace.importer.external.metadatamapping.contributor.MetadataContributor;

public class CombinedMetadatumContributor<T>
implements MetadataContributor<T> {
    private MetadataFieldConfig field;
    private LinkedList<MetadataContributor> metadatumContributors;
    private String separator;
    private MetadataFieldMapping<T, MetadataContributor<T>> metadataFieldMapping;

    public CombinedMetadatumContributor() {
    }

    public CombinedMetadatumContributor(MetadataFieldConfig field, List<MetadataContributor> metadatumContributors, String separator) {
        this.field = field;
        this.metadatumContributors = (LinkedList)metadatumContributors;
        this.separator = separator;
    }

    @Override
    public void setMetadataFieldMapping(MetadataFieldMapping<T, MetadataContributor<T>> metadataFieldMapping) {
        this.metadataFieldMapping = metadataFieldMapping;
        for (MetadataContributor metadatumContributor : this.metadatumContributors) {
            metadatumContributor.setMetadataFieldMapping(metadataFieldMapping);
        }
    }

    @Override
    public Collection<MetadatumDTO> contributeMetadata(T t) {
        LinkedList<MetadatumDTO> values = new LinkedList<MetadatumDTO>();
        LinkedList<LinkedList<MetadatumDTO>> metadatumLists = new LinkedList<LinkedList<MetadatumDTO>>();
        for (MetadataContributor metadatumContributor : this.metadatumContributors) {
            LinkedList<MetadatumDTO> metadatums = new LinkedList<MetadatumDTO>(metadatumContributor.contributeMetadata(t));
            if (metadatums.isEmpty()) continue;
            metadatumLists.add(metadatums);
        }
        if (metadatumLists.isEmpty()) {
            return values;
        }
        int maxSize = metadatumLists.stream().mapToInt(List::size).max().orElse(0);
        for (int i = 0; i < maxSize; ++i) {
            StringBuilder value = new StringBuilder();
            for (List list : metadatumLists) {
                if (i < list.size()) {
                    value.append(((MetadatumDTO)list.get(i)).getValue());
                }
                if (list.equals(metadatumLists.get(metadatumLists.size() - 1))) continue;
                value.append(this.separator);
            }
            values.add(this.metadataFieldMapping.toDCValue(this.field, value.toString()));
        }
        return values;
    }

    public MetadataFieldConfig getField() {
        return this.field;
    }

    public void setField(MetadataFieldConfig field) {
        this.field = field;
    }

    public LinkedList<MetadataContributor> getMetadatumContributors() {
        return this.metadatumContributors;
    }

    public void setMetadatumContributors(LinkedList<MetadataContributor> metadatumContributors) {
        this.metadatumContributors = metadatumContributors;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }
}

