/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.io.Serializable;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.dspace.content.Collection;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.core.HibernateProxyHelper;
import org.dspace.eperson.EPerson;

@Entity
@Table(name="workspaceitem")
public class WorkspaceItem
implements InProgressSubmission,
Serializable {
    @Id
    @Column(name="workspace_item_id", unique=true, nullable=false)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="workspaceitem_seq")
    @SequenceGenerator(name="workspaceitem_seq", sequenceName="workspaceitem_seq", allocationSize=1)
    private Integer workspaceItemId;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="item_id")
    private Item item;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="collection_id")
    private Collection collection;
    @Column(name="multiple_titles")
    private boolean multipleTitles = false;
    @Column(name="published_before")
    private boolean publishedBefore = false;
    @Column(name="multiple_files")
    private boolean multipleFiles = false;
    @Column(name="stage_reached")
    private Integer stageReached = -1;
    @Column(name="page_reached")
    private Integer pageReached = -1;

    protected WorkspaceItem() {
    }

    @Override
    public Integer getID() {
        return this.workspaceItemId;
    }

    public int getStageReached() {
        return this.stageReached;
    }

    public void setStageReached(int v) {
        this.stageReached = v;
    }

    public int getPageReached() {
        return this.pageReached;
    }

    public void setPageReached(int v) {
        this.pageReached = v;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        Class objClass = HibernateProxyHelper.getClassWithoutInitializingProxy(o);
        if (!this.getClass().equals(objClass)) {
            return false;
        }
        WorkspaceItem that = (WorkspaceItem)o;
        return this.getID().equals(that.getID());
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getID()).toHashCode();
    }

    @Override
    public Item getItem() {
        return this.item;
    }

    void setItem(Item item) {
        this.item = item;
    }

    @Override
    public Collection getCollection() {
        return this.collection;
    }

    void setCollection(Collection collection) {
        this.collection = collection;
    }

    @Override
    public EPerson getSubmitter() {
        return this.item.getSubmitter();
    }

    @Override
    public boolean hasMultipleFiles() {
        return this.multipleFiles;
    }

    @Override
    public void setMultipleFiles(boolean b) {
        this.multipleFiles = b;
    }

    @Override
    public boolean hasMultipleTitles() {
        return this.multipleTitles;
    }

    @Override
    public void setMultipleTitles(boolean b) {
        this.multipleTitles = b;
    }

    @Override
    public boolean isPublishedBefore() {
        return this.publishedBefore;
    }

    @Override
    public void setPublishedBefore(boolean b) {
        this.publishedBefore = b;
    }
}

