/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import org.dspace.content.CacheableDSpaceObject;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.SiteService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;

@Entity
@Table(name="site")
public class Site
extends CacheableDSpaceObject {
    @Transient
    private transient SiteService siteService;

    protected Site() {
    }

    @Override
    public int getType() {
        return 5;
    }

    @Override
    public String getName() {
        return this.getSiteService().getName(this);
    }

    public String getURL() {
        ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
        return configurationService.getProperty("dspace.ui.url");
    }

    private SiteService getSiteService() {
        if (this.siteService == null) {
            this.siteService = ContentServiceFactory.getInstance().getSiteService();
        }
        return this.siteService;
    }
}

