/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import org.dspace.content.EntityType;
import org.dspace.core.ReloadableEntity;
import org.hibernate.annotations.JdbcTypeCode;

@Entity
@Table(name="relationship_type")
public class RelationshipType
implements ReloadableEntity<Integer> {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="relationship_type_id_seq")
    @SequenceGenerator(name="relationship_type_id_seq", sequenceName="relationship_type_id_seq", allocationSize=1)
    @Column(name="id", unique=true, nullable=false, insertable=true, updatable=false)
    protected Integer id;
    @ManyToOne(fetch=FetchType.EAGER, cascade={CascadeType.PERSIST})
    @JoinColumn(name="left_type", nullable=false)
    private EntityType leftType;
    @ManyToOne(fetch=FetchType.EAGER, cascade={CascadeType.PERSIST})
    @JoinColumn(name="right_type", nullable=false)
    private EntityType rightType;
    @Column(name="leftward_type", nullable=false)
    private String leftwardType;
    @Column(name="rightward_type", nullable=false)
    private String rightwardType;
    @Column(name="left_min_cardinality")
    private Integer leftMinCardinality;
    @Column(name="left_max_cardinality")
    private Integer leftMaxCardinality;
    @Column(name="right_min_cardinality")
    private Integer rightMinCardinality;
    @Column(name="right_max_cardinality")
    private Integer rightMaxCardinality;
    @Column(name="copy_to_left", nullable=false)
    private boolean copyToLeft;
    @Column(name="copy_to_right", nullable=false)
    private boolean copyToRight;
    @Column(name="tilted")
    @JdbcTypeCode(value=4)
    private Tilted tilted;

    protected RelationshipType() {
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public EntityType getLeftType() {
        return this.leftType;
    }

    public void setLeftType(EntityType leftType) {
        this.leftType = leftType;
    }

    public EntityType getRightType() {
        return this.rightType;
    }

    public void setRightType(EntityType rightType) {
        this.rightType = rightType;
    }

    public String getLeftwardType() {
        return this.leftwardType;
    }

    public void setLeftwardType(String leftwardType) {
        this.leftwardType = leftwardType;
    }

    public String getRightwardType() {
        return this.rightwardType;
    }

    public void setRightwardType(String rightwardType) {
        this.rightwardType = rightwardType;
    }

    public Integer getLeftMinCardinality() {
        return this.leftMinCardinality;
    }

    public void setLeftMinCardinality(Integer leftMinCardinality) {
        this.leftMinCardinality = leftMinCardinality;
    }

    public Integer getLeftMaxCardinality() {
        return this.leftMaxCardinality;
    }

    public void setLeftMaxCardinality(Integer leftMaxCardinality) {
        this.leftMaxCardinality = leftMaxCardinality;
    }

    public Integer getRightMinCardinality() {
        return this.rightMinCardinality;
    }

    public void setRightMinCardinality(Integer rightMinCardinality) {
        this.rightMinCardinality = rightMinCardinality;
    }

    public Integer getRightMaxCardinality() {
        return this.rightMaxCardinality;
    }

    public void setRightMaxCardinality(Integer rightMaxCardinality) {
        this.rightMaxCardinality = rightMaxCardinality;
    }

    public boolean isCopyToLeft() {
        return this.copyToLeft;
    }

    public void setCopyToLeft(boolean copyToLeft) {
        this.copyToLeft = copyToLeft;
    }

    public boolean isCopyToRight() {
        return this.copyToRight;
    }

    public void setCopyToRight(boolean copyToRight) {
        this.copyToRight = copyToRight;
    }

    public Tilted getTilted() {
        return this.tilted;
    }

    public void setTilted(Tilted tilted) {
        this.tilted = tilted;
    }

    @Override
    public Integer getID() {
        return this.id;
    }

    public static enum Tilted {
        NONE,
        LEFT,
        RIGHT;

    }
}

