/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.itemupdate;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.itemupdate.DtoMetadata;
import org.dspace.app.itemupdate.ItemUpdate;
import org.dspace.app.itemupdate.MetadataUtilities;
import org.dspace.app.util.LocalSchemaFilenameFilter;
import org.dspace.app.util.XMLUtils;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.w3c.dom.Document;

public class ItemArchive {
    private static final Logger log = LogManager.getLogger(ItemArchive.class);
    public static final String DUBLIN_CORE_XML = "dublin_core.xml";
    protected Transformer transformer = null;
    protected List<DtoMetadata> dtomList = null;
    protected List<DtoMetadata> undoDtomList = new ArrayList<DtoMetadata>();
    protected List<UUID> undoAddContents = new ArrayList<UUID>();
    protected Item item;
    protected File dir;
    protected String dirname;
    protected HandleService handleService = HandleServiceFactory.getInstance().getHandleService();
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();

    protected ItemArchive() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ItemArchive create(Context context, File dir, String itemField) throws Exception {
        ItemArchive itarch = new ItemArchive();
        itarch.dir = dir;
        itarch.dirname = dir.getName();
        try (InputStream is = null;){
            is = new FileInputStream(new File(dir, DUBLIN_CORE_XML));
            itarch.dtomList = MetadataUtilities.loadDublinCore(XMLUtils.getDocumentBuilder(), is);
            File[] file = dir.listFiles(new LocalSchemaFilenameFilter());
            for (int i = 0; i < file.length; ++i) {
                is = new FileInputStream(file[i]);
                itarch.dtomList.addAll(MetadataUtilities.loadDublinCore(XMLUtils.getDocumentBuilder(), is));
            }
        }
        ItemUpdate.pr("Loaded metadata with " + itarch.dtomList.size() + " fields");
        itarch.item = itemField == null ? itarch.itemFromHandleInput(context) : itarch.itemFromMetadataField(context, itemField);
        if (itarch.item == null) {
            throw new Exception("Item not instantiated: " + itarch.dirname);
        }
        ItemUpdate.prv("item instantiated: " + itarch.item.getHandle());
        return itarch;
    }

    protected Transformer getTransformer() throws TransformerConfigurationException {
        if (this.transformer == null) {
            this.transformer = TransformerFactory.newInstance().newTransformer();
        }
        return this.transformer;
    }

    public Item getItem() {
        return this.item;
    }

    public File getDirectory() {
        return this.dir;
    }

    public String getDirectoryName() {
        return this.dirname;
    }

    public void addUndoMetadataField(DtoMetadata dtom) {
        this.undoDtomList.add(dtom);
    }

    public List<DtoMetadata> getMetadataFields() {
        return this.dtomList;
    }

    public void addUndoDeleteContents(UUID bitstreamId) {
        this.undoAddContents.add(bitstreamId);
    }

    private Item itemFromHandleInput(Context context) throws SQLException, Exception {
        DtoMetadata dtom = this.getMetadataField("dc.identifier.uri");
        if (dtom == null) {
            throw new Exception("No dc.identifier.uri field found for handle");
        }
        this.addUndoMetadataField(dtom);
        String uri = dtom.value;
        if (!uri.startsWith(ItemUpdate.HANDLE_PREFIX)) {
            throw new Exception("dc.identifier.uri for item " + uri + " does not begin with prefix: " + ItemUpdate.HANDLE_PREFIX);
        }
        String handle = uri.substring(ItemUpdate.HANDLE_PREFIX.length());
        DSpaceObject dso = this.handleService.resolveToObject(context, handle);
        if (!(dso instanceof Item)) {
            ItemUpdate.pr("Warning: item not instantiated");
            throw new IllegalArgumentException("Item " + handle + " not instantiated.");
        }
        this.item = (Item)dso;
        return this.item;
    }

    private Item itemFromMetadataField(Context context, String itemField) throws SQLException, AuthorizeException, Exception {
        DtoMetadata dtom = this.getMetadataField(itemField);
        Item item = null;
        if (dtom == null) {
            throw new IllegalArgumentException("No field found for item identifier field: " + itemField);
        }
        ItemUpdate.prv("Metadata field to match for item: " + dtom.toString());
        this.addUndoMetadataField(dtom);
        Iterator<Item> itr = this.itemService.findByMetadataField(context, dtom.schema, dtom.element, dtom.qualifier, dtom.value);
        int count = 0;
        while (itr.hasNext()) {
            item = itr.next();
            ++count;
        }
        ItemUpdate.prv("items matching = " + count);
        if (count != 1) {
            throw new Exception(count + " items matching item identifier: " + dtom.value);
        }
        return item;
    }

    private DtoMetadata getMetadataField(String compoundForm) {
        for (DtoMetadata dtom : this.dtomList) {
            if (!dtom.matches(compoundForm, false)) continue;
            return dtom;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeUndo(File undoDir) throws IOException, ParserConfigurationException, TransformerConfigurationException, TransformerException, FileNotFoundException {
        block9: {
            File dir = new File(undoDir, this.dirname);
            if (!dir.exists() && !dir.mkdir()) {
                log.error("Unable to create undo directory");
            }
            try (OutputStream out = null;){
                out = new FileOutputStream(new File(dir, DUBLIN_CORE_XML));
                Document doc = MetadataUtilities.writeDublinCore(XMLUtils.getDocumentBuilder(), this.undoDtomList);
                MetadataUtilities.writeDocument(doc, this.getTransformer(), out);
                if (this.undoAddContents.size() <= 0) break block9;
                try (PrintWriter pw = null;){
                    File f = new File(dir, "delete_contents");
                    pw = new PrintWriter(new BufferedWriter(new FileWriter(f, StandardCharsets.UTF_8)));
                    for (UUID i : this.undoAddContents) {
                        pw.println(i);
                    }
                }
            }
        }
    }
}

